package com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.entity.Testobject3;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.service.ITestobject3Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * zilei前端控制器
 *
 * @author ultraman
 * @date 2021-10-13
 */
@RestController
public class Testobject3Controller {

  @Autowired
  private ITestobject3Service testobject3ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testobject3 zilei
   * @return
   */
  @GetMapping("/testobject3s" )
  public XfR getTestobject3s(XfPage page, Testobject3 testobject3) {
    return XfR.ok(testobject3ServiceImpl.page(page, Wrappers.query(testobject3)));
  }

  /**
   * 通过id查询zilei
   * @param  id
   * @return XfR
   */
  @GetMapping("/testobject3s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testobject3ServiceImpl.getById(id));
  }

  /**
   * 新增zilei
   * @param testobject3 zilei
   * @return XfR
   */
  @PostMapping("/testobject3s")
  public XfR save(@RequestBody Testobject3 testobject3) {
     return XfR.ok(testobject3ServiceImpl.save(testobject3));
  }

  /**
   * 修改-传入修改后的全部数据zilei
   * @param testobject3 zilei
   * @return XfR
   */
  @PutMapping("/testobject3s/{id}")
  public XfR putUpdate(@RequestBody Testobject3 testobject3,@PathVariable Long id) {
      testobject3.setId(id);
      return XfR.ok(testobject3ServiceImpl.updateById(testobject3));
  }

  /**
   * 修改-传入修改的数据zilei
   * @param testobject3 zilei
   * @return XfR
   */
  @PatchMapping("/testobject3s/{id}")
  public XfR patchUpdate(@RequestBody Testobject3 testobject3,@PathVariable Long id) {
      Testobject3 uptestobject3 = testobject3ServiceImpl.getById(id);
      if(uptestobject3 != null){
        uptestobject3 = ObjectCopyUtils.copyProperties(testobject3,uptestobject3,true);
      }
      return XfR.ok(testobject3ServiceImpl.updateById(uptestobject3));
  }

  /**
   * 通过id删除zilei
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testobject3s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testobject3ServiceImpl.removeById(id));
  }

  @PostMapping("/testobject3s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testobject3");
     params.put("request", condition);

     return XfR.ok(testobject3ServiceImpl.querys(params));
  }

}
