package com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.entity.Xinfudianxing;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.service.IXinfudianxingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 1.21后验证长度前端控制器
 *
 * @author ultraman
 * @date 2021-10-13
 */
@RestController
public class XinfudianxingController {

  @Autowired
  private IXinfudianxingService xinfudianxingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param xinfudianxing 1.21后验证长度
   * @return
   */
  @GetMapping("/xinfudianxings" )
  public XfR getXinfudianxings(XfPage page, Xinfudianxing xinfudianxing) {
    return XfR.ok(xinfudianxingServiceImpl.page(page, Wrappers.query(xinfudianxing)));
  }

  /**
   * 通过id查询1.21后验证长度
   * @param  id
   * @return XfR
   */
  @GetMapping("/xinfudianxings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(xinfudianxingServiceImpl.getById(id));
  }

  /**
   * 新增1.21后验证长度
   * @param xinfudianxing 1.21后验证长度
   * @return XfR
   */
  @PostMapping("/xinfudianxings")
  public XfR save(@RequestBody Xinfudianxing xinfudianxing) {
     return XfR.ok(xinfudianxingServiceImpl.save(xinfudianxing));
  }

  /**
   * 修改-传入修改后的全部数据1.21后验证长度
   * @param xinfudianxing 1.21后验证长度
   * @return XfR
   */
  @PutMapping("/xinfudianxings/{id}")
  public XfR putUpdate(@RequestBody Xinfudianxing xinfudianxing,@PathVariable Long id) {
      xinfudianxing.setId(id);
      return XfR.ok(xinfudianxingServiceImpl.updateById(xinfudianxing));
  }

  /**
   * 修改-传入修改的数据1.21后验证长度
   * @param xinfudianxing 1.21后验证长度
   * @return XfR
   */
  @PatchMapping("/xinfudianxings/{id}")
  public XfR patchUpdate(@RequestBody Xinfudianxing xinfudianxing,@PathVariable Long id) {
      Xinfudianxing upxinfudianxing = xinfudianxingServiceImpl.getById(id);
      if(upxinfudianxing != null){
        upxinfudianxing = ObjectCopyUtils.copyProperties(xinfudianxing,upxinfudianxing,true);
      }
      return XfR.ok(xinfudianxingServiceImpl.updateById(upxinfudianxing));
  }

  /**
   * 通过id删除1.21后验证长度
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/xinfudianxings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(xinfudianxingServiceImpl.removeById(id));
  }

  @PostMapping("/xinfudianxings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "xinfudianxing");
     params.put("request", condition);

     return XfR.ok(xinfudianxingServiceImpl.querys(params));
  }

}
