package com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.entity.YanzhengfucChild;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.service.IYanzhengfucChildService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * yanzhengfucChild前端控制器
 *
 * @author ultraman
 * @date 2021-10-13
 */
@RestController
public class YanzhengfucChildController {

  @Autowired
  private IYanzhengfucChildService yanzhengfucChildServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param yanzhengfucChild yanzhengfucChild
   * @return
   */
  @GetMapping("/yanzhengfucchilds" )
  public XfR getYanzhengfucChilds(XfPage page, YanzhengfucChild yanzhengfucChild) {
    return XfR.ok(yanzhengfucChildServiceImpl.page(page, Wrappers.query(yanzhengfucChild)));
  }

  /**
   * 通过id查询yanzhengfucChild
   * @param  id
   * @return XfR
   */
  @GetMapping("/yanzhengfucchilds/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(yanzhengfucChildServiceImpl.getById(id));
  }

  /**
   * 新增yanzhengfucChild
   * @param yanzhengfucChild yanzhengfucChild
   * @return XfR
   */
  @PostMapping("/yanzhengfucchilds")
  public XfR save(@RequestBody YanzhengfucChild yanzhengfucChild) {
     return XfR.ok(yanzhengfucChildServiceImpl.save(yanzhengfucChild));
  }

  /**
   * 修改-传入修改后的全部数据yanzhengfucChild
   * @param yanzhengfucChild yanzhengfucChild
   * @return XfR
   */
  @PutMapping("/yanzhengfucchilds/{id}")
  public XfR putUpdate(@RequestBody YanzhengfucChild yanzhengfucChild,@PathVariable Long id) {
      yanzhengfucChild.setId(id);
      return XfR.ok(yanzhengfucChildServiceImpl.updateById(yanzhengfucChild));
  }

  /**
   * 修改-传入修改的数据yanzhengfucChild
   * @param yanzhengfucChild yanzhengfucChild
   * @return XfR
   */
  @PatchMapping("/yanzhengfucchilds/{id}")
  public XfR patchUpdate(@RequestBody YanzhengfucChild yanzhengfucChild,@PathVariable Long id) {
      YanzhengfucChild upyanzhengfucChild = yanzhengfucChildServiceImpl.getById(id);
      if(upyanzhengfucChild != null){
        upyanzhengfucChild = ObjectCopyUtils.copyProperties(yanzhengfucChild,upyanzhengfucChild,true);
      }
      return XfR.ok(yanzhengfucChildServiceImpl.updateById(upyanzhengfucChild));
  }

  /**
   * 通过id删除yanzhengfucChild
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/yanzhengfucchilds/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(yanzhengfucChildServiceImpl.removeById(id));
  }

  @PostMapping("/yanzhengfucchilds/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "yanzhengfuc_child");
     params.put("request", condition);

     return XfR.ok(yanzhengfucChildServiceImpl.querys(params));
  }

}
