package com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.entity.Yanzhengfuc;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.service.IYanzhengfucService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 回归验证fuction前端控制器
 *
 * @author ultraman
 * @date 2021-10-13
 */
@RestController
public class YanzhengfucController {

  @Autowired
  private IYanzhengfucService yanzhengfucServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param yanzhengfuc 回归验证fuction
   * @return
   */
  @GetMapping("/yanzhengfucs" )
  public XfR getYanzhengfucs(XfPage page, Yanzhengfuc yanzhengfuc) {
    return XfR.ok(yanzhengfucServiceImpl.page(page, Wrappers.query(yanzhengfuc)));
  }

  /**
   * 通过id查询回归验证fuction
   * @param  id
   * @return XfR
   */
  @GetMapping("/yanzhengfucs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(yanzhengfucServiceImpl.getById(id));
  }

  /**
   * 新增回归验证fuction
   * @param yanzhengfuc 回归验证fuction
   * @return XfR
   */
  @PostMapping("/yanzhengfucs")
  public XfR save(@RequestBody Yanzhengfuc yanzhengfuc) {
     return XfR.ok(yanzhengfucServiceImpl.save(yanzhengfuc));
  }

  /**
   * 修改-传入修改后的全部数据回归验证fuction
   * @param yanzhengfuc 回归验证fuction
   * @return XfR
   */
  @PutMapping("/yanzhengfucs/{id}")
  public XfR putUpdate(@RequestBody Yanzhengfuc yanzhengfuc,@PathVariable Long id) {
      yanzhengfuc.setId(id);
      return XfR.ok(yanzhengfucServiceImpl.updateById(yanzhengfuc));
  }

  /**
   * 修改-传入修改的数据回归验证fuction
   * @param yanzhengfuc 回归验证fuction
   * @return XfR
   */
  @PatchMapping("/yanzhengfucs/{id}")
  public XfR patchUpdate(@RequestBody Yanzhengfuc yanzhengfuc,@PathVariable Long id) {
      Yanzhengfuc upyanzhengfuc = yanzhengfucServiceImpl.getById(id);
      if(upyanzhengfuc != null){
        upyanzhengfuc = ObjectCopyUtils.copyProperties(yanzhengfuc,upyanzhengfuc,true);
      }
      return XfR.ok(yanzhengfucServiceImpl.updateById(upyanzhengfuc));
  }

  /**
   * 通过id删除回归验证fuction
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/yanzhengfucs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(yanzhengfucServiceImpl.removeById(id));
  }

  @PostMapping("/yanzhengfucs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "yanzhengfuc");
     params.put("request", condition);

     return XfR.ok(yanzhengfucServiceImpl.querys(params));
  }

}
