package com.xforceplus.ultraman.app.zidonghualiu1012.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * zdhl0221003
 * </p>
 *
 * @author ultraman
 * @since 2023-05-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Zdhl0221003 implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * zfc3
   */
  private String zfc3;

  /**
   * bez3
   */
  private Boolean bez3;

  /**
   * zx3
   */
  private Long zx3;

  /**
   * riqi3
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime riqi3;

  /**
   * xs3
   */
  private BigDecimal xs3;

  /**
   * jine3
   */
  private BigDecimal jine3;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("zfc3", zfc3);
      map.put("bez3", bez3);
      map.put("zx3", zx3);
      map.put("riqi3", BocpGenUtils.toTimestamp(riqi3));
      map.put("xs3", xs3);
      map.put("jine3", jine3);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static Zdhl0221003 fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Zdhl0221003 entity = new Zdhl0221003();
    if(map.containsKey("zfc3")) {
      Object obj = map.get("zfc3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setZfc3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bez3")) {
      Object obj = map.get("bez3");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setBez3((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setBez3(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("zx3")) {
      Object obj = map.get("zx3");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setZx3((Long)obj);
        } else if(obj instanceof String) {
          entity.setZx3(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setZx3(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("riqi3")) {
      Object obj = map.get("riqi3");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRiqi3(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRiqi3((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setRiqi3(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRiqi3(null);
      }
    }
    if(map.containsKey("xs3")) {
      Object obj = map.get("xs3");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setXs3((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setXs3(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setXs3(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setXs3(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setXs3(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("jine3")) {
      Object obj = map.get("jine3");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setJine3((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setJine3(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setJine3(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setJine3(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setJine3(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("zfc3")) {
      Object obj = map.get("zfc3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZfc3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bez3")) {
      Object obj = map.get("bez3");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setBez3((Boolean)obj);
        } else if(obj instanceof String) {
          this.setBez3(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("zx3")) {
      Object obj = map.get("zx3");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setZx3((Long)obj);
        } else if(obj instanceof String) {
          this.setZx3(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setZx3(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("riqi3")) {
      Object obj = map.get("riqi3");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRiqi3(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRiqi3((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setRiqi3(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRiqi3(null);
      }
    }
    if(map.containsKey("xs3")) {
      Object obj = map.get("xs3");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setXs3((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setXs3(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setXs3(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setXs3(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setXs3(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("jine3")) {
      Object obj = map.get("jine3");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setJine3((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setJine3(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setJine3(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setJine3(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setJine3(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
