package com.xforceplus.ultraman.app.zidonghualiu1012.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * lookup032301
 * </p>
 *
 * @author ultraman
 * @since 2023-07-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Lookup032301 implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * zfc
   */
  private String zfc;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * lookupzfc
   */
  private String lookupzfc;

  /**
   * lookupzfcjh
   */
  private String lookupzfcjh;

  /**
   * lookupcszbh
   */
  private Long lookupcszbh;

  /**
   * lookupzx
   */
  private Long lookupzx;

  /**
   * lookupxs
   */
  private BigDecimal lookupxs;

  /**
   * lookupjine
   */
  private BigDecimal lookupjine;

  /**
   * lookupbez
   */
  private Boolean lookupbez;

  /**
   * lookupsjc
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime lookupsjc;

  /**
   * lookupmjx
   */
  private String lookupmjx;

  /**
   * lookup
   */
  private String lookup;


  /**
   * 对一关联关系 关联对象 beilookup032301
   */
    private Long lookupgx032301Id;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("zfc", zfc);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("lookupzfc", lookupzfc);
      map.put("lookupzfcjh", lookupzfcjh);
      map.put("lookupcszbh", lookupcszbh);
      map.put("lookupzx", lookupzx);
      map.put("lookupxs", lookupxs);
      map.put("lookupjine", lookupjine);
      map.put("lookupbez", lookupbez);
      map.put("lookupsjc", BocpGenUtils.toTimestamp(lookupsjc));
      map.put("lookupmjx", lookupmjx);
      map.put("lookup", lookup);

       map.put("lookupgx032301.id", lookupgx032301Id);
      return map;
  }

  public static Lookup032301 fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Lookup032301 entity = new Lookup032301();
    if(map.containsKey("zfc")) {
      Object obj = map.get("zfc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZfc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupzfc")) {
      Object obj = map.get("lookupzfc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLookupzfc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupzfcjh")) {
      Object obj = map.get("lookupzfcjh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLookupzfcjh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupcszbh")) {
      Object obj = map.get("lookupcszbh");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLookupcszbh((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLookupcszbh(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLookupcszbh(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("lookupzx")) {
      Object obj = map.get("lookupzx");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLookupzx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLookupzx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLookupzx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("lookupxs")) {
      Object obj = map.get("lookupxs");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setLookupxs((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setLookupxs(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setLookupxs(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLookupxs(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLookupxs(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("lookupjine")) {
      Object obj = map.get("lookupjine");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setLookupjine((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setLookupjine(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setLookupjine(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLookupjine(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLookupjine(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("lookupbez")) {
      Object obj = map.get("lookupbez");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLookupbez((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLookupbez(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("lookupsjc")) {
      Object obj = map.get("lookupsjc");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLookupsjc(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setLookupsjc((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLookupsjc(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLookupsjc(null);
      }
    }
    if(map.containsKey("lookupmjx")) {
      Object obj = map.get("lookupmjx");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLookupmjx((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookup")) {
      Object obj = map.get("lookup");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLookup((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("lookupgx032301.id")) {
        Object obj = map.get("lookupgx032301.id");
      if(obj instanceof Long) {
        entity.setLookupgx032301Id((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setLookupgx032301Id(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("zfc")) {
      Object obj = map.get("zfc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZfc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lookupzfc")) {
      Object obj = map.get("lookupzfc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLookupzfc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lookupzfcjh")) {
      Object obj = map.get("lookupzfcjh");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLookupzfcjh((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lookupcszbh")) {
      Object obj = map.get("lookupcszbh");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLookupcszbh((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLookupcszbh(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setLookupcszbh(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("lookupzx")) {
      Object obj = map.get("lookupzx");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLookupzx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLookupzx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setLookupzx(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("lookupxs")) {
      Object obj = map.get("lookupxs");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setLookupxs((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setLookupxs(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setLookupxs(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLookupxs(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setLookupxs(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("lookupjine")) {
      Object obj = map.get("lookupjine");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setLookupjine((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setLookupjine(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setLookupjine(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLookupjine(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setLookupjine(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("lookupbez")) {
      Object obj = map.get("lookupbez");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLookupbez((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLookupbez(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("lookupsjc")) {
      Object obj = map.get("lookupsjc");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLookupsjc(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setLookupsjc((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLookupsjc(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setLookupsjc(null);
      }
    }
    if(map.containsKey("lookupmjx")) {
      Object obj = map.get("lookupmjx");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLookupmjx((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lookup")) {
      Object obj = map.get("lookup");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLookup((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("lookupgx032301.id")) {
        Object obj = map.get("lookupgx032301.id");
        if(obj instanceof Long) {
          this.setLookupgx032301Id((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLookupgx032301Id(Long.parseLong((String)obj));
        }
      }
  }
}
