package com.xforceplus.ultraman.app.zuhuguanli0918001cqp.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * is_repeat
 * </p>
 *
 * @author ultraman
 * @since 2024-08-08
 */
public enum IsRepeat {

    _0("0", "否"),
    _1("1", "是");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IsRepeat(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsRepeat fromCode(String code) {
        return Stream.of(IsRepeat.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
