package com.xforceplus.ultraman.app.zuhuguanli0918001cqp.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * retreat_status
 * </p>
 *
 * @author ultraman
 * @since 2024-08-08
 */
public enum RetreatStatus {

    _0("0", "未退票"),
    _1("1", "已退票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RetreatStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RetreatStatus fromCode(String code) {
        return Stream.of(RetreatStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
