package com.xforceplus.ultraman.app.zuhuguanli0918001cqp.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * test1020001
 * </p>
 *
 * @author ultraman
 * @since 2024-08-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Test1020001 implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * zx
   */
  private Long zx;
  /**
   * cszbh
   */
  private Long cszbh;
  /**
   * bez
   */
  private Boolean bez;
  /**
   * riqi
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime riqi;
  /**
   * zfcdt
   */
  private String zfcdt;
  /**
   * xsdt
   */
  private BigDecimal xsdt;
  /**
   * jinedt
   */
  private BigDecimal jinedt;
  /**
   * zxdt
   */
  private Long zxdt;
  /**
   * cszbhdt
   */
  private Long cszbhdt;
  /**
   * bezdt
   */
  private Boolean bezdt;
  /**
   * riqidt
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime riqidt;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * mjx0605001
   */
  private String mjx0605001;
  /**
   * mjx0605001dt
   */
  private String mjx0605001dt;
  /**
   * addzfc
   */
  private String addzfc;
  /**
   * addmjx1018001
   */
  private String addmjx1018001;
  /**
   * mjx1020001
   */
  private String mjx1020001;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("zx", zx);
      map.put("cszbh", cszbh);
      map.put("bez", bez);
      map.put("riqi", BocpGenUtils.toTimestamp(riqi));
      map.put("zfcdt", zfcdt);
      map.put("xsdt", xsdt);
      map.put("jinedt", jinedt);
      map.put("zxdt", zxdt);
      map.put("cszbhdt", cszbhdt);
      map.put("bezdt", bezdt);
      map.put("riqidt", BocpGenUtils.toTimestamp(riqidt));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("mjx0605001", mjx0605001);
      map.put("mjx0605001dt", mjx0605001dt);
      map.put("addzfc", addzfc);
      map.put("addmjx1018001", addmjx1018001);
      map.put("mjx1020001", mjx1020001);

      return map;
  }

  public static Test1020001 fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    Test1020001 entity = new Test1020001();

    if(map.containsKey("zx")) {
      Object obj = map.get("zx");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setZx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setZx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setZx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("cszbh")) {
      Object obj = map.get("cszbh");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCszbh((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCszbh(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCszbh(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("bez")) {
      Object obj = map.get("bez");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setBez((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBez(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("riqi")) {
      Object obj = map.get("riqi");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRiqi(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setRiqi((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRiqi(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRiqi(null);
      }
    }
    if(map.containsKey("zfcdt")) {
      Object obj = map.get("zfcdt");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZfcdt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xsdt")) {
      Object obj = map.get("xsdt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setXsdt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setXsdt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setXsdt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setXsdt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setXsdt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("jinedt")) {
      Object obj = map.get("jinedt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setJinedt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setJinedt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setJinedt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJinedt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setJinedt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("zxdt")) {
      Object obj = map.get("zxdt");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setZxdt((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setZxdt(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setZxdt(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("cszbhdt")) {
      Object obj = map.get("cszbhdt");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCszbhdt((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCszbhdt(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCszbhdt(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("bezdt")) {
      Object obj = map.get("bezdt");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setBezdt((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBezdt(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("riqidt")) {
      Object obj = map.get("riqidt");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRiqidt(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setRiqidt((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRiqidt(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRiqidt(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mjx0605001")) {
      Object obj = map.get("mjx0605001");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMjx0605001((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mjx0605001dt")) {
      Object obj = map.get("mjx0605001dt");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMjx0605001dt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addzfc")) {
      Object obj = map.get("addzfc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddzfc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addmjx1018001")) {
      Object obj = map.get("addmjx1018001");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddmjx1018001((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mjx1020001")) {
      Object obj = map.get("mjx1020001");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMjx1020001((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("zx")) {
      Object obj = map.get("zx");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setZx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setZx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setZx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("cszbh")) {
      Object obj = map.get("cszbh");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCszbh((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCszbh(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCszbh(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("bez")) {
      Object obj = map.get("bez");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setBez((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBez(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("riqi")) {
      Object obj = map.get("riqi");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRiqi(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setRiqi((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRiqi(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setRiqi(null);
      }
    }
    if(map.containsKey("zfcdt")) {
      Object obj = map.get("zfcdt");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setZfcdt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xsdt")) {
      Object obj = map.get("xsdt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setXsdt((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setXsdt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setXsdt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setXsdt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setXsdt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("jinedt")) {
      Object obj = map.get("jinedt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setJinedt((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setJinedt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setJinedt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setJinedt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setJinedt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("zxdt")) {
      Object obj = map.get("zxdt");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setZxdt((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setZxdt(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setZxdt(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("cszbhdt")) {
      Object obj = map.get("cszbhdt");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCszbhdt((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCszbhdt(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCszbhdt(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("bezdt")) {
      Object obj = map.get("bezdt");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setBezdt((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBezdt(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("riqidt")) {
      Object obj = map.get("riqidt");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRiqidt(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setRiqidt((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRiqidt(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setRiqidt(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mjx0605001")) {
      Object obj = map.get("mjx0605001");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMjx0605001((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mjx0605001dt")) {
      Object obj = map.get("mjx0605001dt");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMjx0605001dt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addzfc")) {
      Object obj = map.get("addzfc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAddzfc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addmjx1018001")) {
      Object obj = map.get("addmjx1018001");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAddmjx1018001((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mjx1020001")) {
      Object obj = map.get("mjx1020001");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMjx1020001((String)obj);
        }
      } else{
      }
    }
  }
}
