package com.xforceplus.ultraman.app.zuhuguanli0918001cqp.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * workload
 * </p>
 *
 * @author ultraman
 * @since 2024-08-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Workload implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 姓名
   */
  private String userName;
  /**
   * 发票认证
   */
  private Long invoiceAuthCount;
  /**
   * 邮包签收
   */
  private Long parcelSignCount;
  /**
   * 业务单签收
   */
  private Long orderSignCount;
  /**
   * 发票签收
   */
  private Long invoiceSignCount;
  /**
   * 发票审核
   */
  private Long invoiceAuditCount;
  /**
   * 影像上传
   */
  private Long invoiceRecog;
  /**
   * 风险发票
   */
  private Long riskInvoiceCount;
  /**
   * 风险单据
   */
  private Long riskOrderCount;
  /**
   * 风险邮包
   */
  private Long riskParcelCount;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * abc
   */
  private String abcCqp;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("userName", userName);
      map.put("invoiceAuthCount", invoiceAuthCount);
      map.put("parcelSignCount", parcelSignCount);
      map.put("orderSignCount", orderSignCount);
      map.put("invoiceSignCount", invoiceSignCount);
      map.put("invoiceAuditCount", invoiceAuditCount);
      map.put("invoiceRecog", invoiceRecog);
      map.put("riskInvoiceCount", riskInvoiceCount);
      map.put("riskOrderCount", riskOrderCount);
      map.put("riskParcelCount", riskParcelCount);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("abc_CQP", abcCqp);

      return map;
  }

  public static Workload fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    Workload entity = new Workload();

    if(map.containsKey("userName")) {
      Object obj = map.get("userName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAuthCount")) {
      Object obj = map.get("invoiceAuthCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceAuthCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceAuthCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInvoiceAuthCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("parcelSignCount")) {
      Object obj = map.get("parcelSignCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setParcelSignCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setParcelSignCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setParcelSignCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("orderSignCount")) {
      Object obj = map.get("orderSignCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderSignCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderSignCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrderSignCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceSignCount")) {
      Object obj = map.get("invoiceSignCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceSignCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceSignCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInvoiceSignCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAuditCount")) {
      Object obj = map.get("invoiceAuditCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceAuditCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceAuditCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInvoiceAuditCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceRecog")) {
      Object obj = map.get("invoiceRecog");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceRecog((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceRecog(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInvoiceRecog(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("riskInvoiceCount")) {
      Object obj = map.get("riskInvoiceCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRiskInvoiceCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRiskInvoiceCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setRiskInvoiceCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("riskOrderCount")) {
      Object obj = map.get("riskOrderCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRiskOrderCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRiskOrderCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setRiskOrderCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("riskParcelCount")) {
      Object obj = map.get("riskParcelCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRiskParcelCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRiskParcelCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setRiskParcelCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("abc_CQP")) {
      Object obj = map.get("abc_CQP");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAbcCqp((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("userName")) {
      Object obj = map.get("userName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAuthCount")) {
      Object obj = map.get("invoiceAuthCount");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setInvoiceAuthCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInvoiceAuthCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setInvoiceAuthCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("parcelSignCount")) {
      Object obj = map.get("parcelSignCount");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setParcelSignCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setParcelSignCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setParcelSignCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("orderSignCount")) {
      Object obj = map.get("orderSignCount");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOrderSignCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOrderSignCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setOrderSignCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceSignCount")) {
      Object obj = map.get("invoiceSignCount");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setInvoiceSignCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInvoiceSignCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setInvoiceSignCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAuditCount")) {
      Object obj = map.get("invoiceAuditCount");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setInvoiceAuditCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInvoiceAuditCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setInvoiceAuditCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceRecog")) {
      Object obj = map.get("invoiceRecog");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setInvoiceRecog((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInvoiceRecog(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setInvoiceRecog(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("riskInvoiceCount")) {
      Object obj = map.get("riskInvoiceCount");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRiskInvoiceCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRiskInvoiceCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setRiskInvoiceCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("riskOrderCount")) {
      Object obj = map.get("riskOrderCount");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRiskOrderCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRiskOrderCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setRiskOrderCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("riskParcelCount")) {
      Object obj = map.get("riskParcelCount");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRiskParcelCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRiskParcelCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setRiskParcelCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("abc_CQP")) {
      Object obj = map.get("abc_CQP");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAbcCqp((String)obj);
        }
      } else{
      }
    }
  }
}
