package com.xforceplus.ultraman.app.zuhuguanli0918001cqp.metadata.validator;

import com.xforceplus.ultraman.app.zuhuguanli0918001cqp.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.zuhuguanli0918001cqp.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-08-08
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx0918001.class)) {
            isValid = null != Mjx0918001.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Mjx0918001.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx1007001.class)) {
            isValid = null != Mjx1007001.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Mjx1007001.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx0605001.class)) {
            isValid = null != Mjx0605001.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Mjx0605001.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx1018001.class)) {
            isValid = null != Mjx1018001.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Mjx1018001.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx1020001.class)) {
            isValid = null != Mjx1020001.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Mjx1020001.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx1023001.class)) {
            isValid = null != Mjx1023001.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Mjx1023001.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx1023002.class)) {
            isValid = null != Mjx1023002.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Mjx1023002.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx1024001.class)) {
            isValid = null != Mjx1024001.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Mjx1024001.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx1024002.class)) {
            isValid = null != Mjx1024002.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Mjx1024002.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx1024003.class)) {
            isValid = null != Mjx1024003.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Mjx1024003.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx1025001.class)) {
            isValid = null != Mjx1025001.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Mjx1025001.class.getSimpleName());
            }
        }
        if(clazz.equals(RecogStatus.class)) {
            isValid = null != RecogStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RecogStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RecogSheet.class)) {
            isValid = null != RecogSheet.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RecogSheet.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = null != MatchStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CooperateFlag.class)) {
            isValid = null != CooperateFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CooperateFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(ComplianceStatus.class)) {
            isValid = null != ComplianceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ComplianceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RetreatStatus.class)) {
            isValid = null != RetreatStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RetreatStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(HangStatus.class)) {
            isValid = null != HangStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, HangStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SignForStatus.class)) {
            isValid = null != SignForStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SignForStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeUpStatus.class)) {
            isValid = null != ChargeUpStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeUpStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentStatus.class)) {
            isValid = null != PaymentStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PaymentStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BlackStatus.class)) {
            isValid = null != BlackStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BlackStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TurnOutStatus.class)) {
            isValid = null != TurnOutStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TurnOutStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TurnOutType.class)) {
            isValid = null != TurnOutType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TurnOutType.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditStatus.class)) {
            isValid = null != AuditStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuditStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DataStatus.class)) {
            isValid = null != DataStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DataStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceBusinessType.class)) {
            isValid = null != InvoiceBusinessType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceBusinessType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceCategory.class)) {
            isValid = null != InvoiceCategory.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceCategory.class.getSimpleName());
            }
        }
        if(clazz.equals(AreaType.class)) {
            isValid = null != AreaType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AreaType.class.getSimpleName());
            }
        }
        if(clazz.equals(IsCancelCheck.class)) {
            isValid = null != IsCancelCheck.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsCancelCheck.class.getSimpleName());
            }
        }
        if(clazz.equals(SaleConfirmStatus.class)) {
            isValid = null != SaleConfirmStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SaleConfirmStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReportStatus.class)) {
            isValid = null != ReportStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReportStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReimbursementStatus.class)) {
            isValid = null != ReimbursementStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReimbursementStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RedStatus.class)) {
            isValid = null != RedStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RedStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(EntryStatus.class)) {
            isValid = null != EntryStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EntryStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(EntryTabStatus.class)) {
            isValid = null != EntryTabStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EntryTabStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(NoComplianceType.class)) {
            isValid = null != NoComplianceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NoComplianceType.class.getSimpleName());
            }
        }
        if(clazz.equals(FollowUpStatus.class)) {
            isValid = null != FollowUpStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FollowUpStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RiskHandleStatus.class)) {
            isValid = null != RiskHandleStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RiskHandleStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessControlStatus.class)) {
            isValid = null != BusinessControlStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BusinessControlStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(FunctionGroup.class)) {
            isValid = null != FunctionGroup.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FunctionGroup.class.getSimpleName());
            }
        }
        if(clazz.equals(FunctionGroupWay.class)) {
            isValid = null != FunctionGroupWay.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FunctionGroupWay.class.getSimpleName());
            }
        }
        if(clazz.equals(UnCertifiedReason.class)) {
            isValid = null != UnCertifiedReason.fromCode(value);
            if(!isValid) {
                unValidMsg(context, UnCertifiedReason.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceExt30.class)) {
            isValid = null != InvoiceExt30.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceExt30.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceExt35.class)) {
            isValid = null != InvoiceExt35.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceExt35.class.getSimpleName());
            }
        }
        if(clazz.equals(RiskInvoiceCategory.class)) {
            isValid = null != RiskInvoiceCategory.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RiskInvoiceCategory.class.getSimpleName());
            }
        }
        if(clazz.equals(IsRepeat.class)) {
            isValid = null != IsRepeat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsRepeat.class.getSimpleName());
            }
        }
        if(clazz.equals(IsNeedAuth.class)) {
            isValid = null != IsNeedAuth.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsNeedAuth.class.getSimpleName());
            }
        }
        if(clazz.equals(IsSendException.class)) {
            isValid = null != IsSendException.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsSendException.class.getSimpleName());
            }
        }
        if(clazz.equals(ReturnType.class)) {
            isValid = null != ReturnType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReturnType.class.getSimpleName());
            }
        }
        if(clazz.equals(ReturnBatch.class)) {
            isValid = null != ReturnBatch.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReturnBatch.class.getSimpleName());
            }
        }
        if(clazz.equals(NeedExpress.class)) {
            isValid = null != NeedExpress.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NeedExpress.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgType.class)) {
            isValid = null != OrgType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrgType.class.getSimpleName());
            }
        }
        if(clazz.equals(CreationMethod.class)) {
            isValid = null != CreationMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CreationMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgStatus.class)) {
            isValid = null != OrgStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrgStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
