package com.xforceplus.ultraman.app.zuhuguanli0918001cqp.metadata.validator;

import com.xforceplus.ultraman.app.zuhuguanli0918001cqp.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.zuhuguanli0918001cqp.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-08-08
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnapshotFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx0918001.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Mjx0918001.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Mjx0918001.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx1007001.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Mjx1007001.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Mjx1007001.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx0605001.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Mjx0605001.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Mjx0605001.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx1018001.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Mjx1018001.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Mjx1018001.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx1020001.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Mjx1020001.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Mjx1020001.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx1023001.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Mjx1023001.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Mjx1023001.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx1023002.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Mjx1023002.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Mjx1023002.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx1024001.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Mjx1024001.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Mjx1024001.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx1024002.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Mjx1024002.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Mjx1024002.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx1024003.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Mjx1024003.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Mjx1024003.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx1025001.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Mjx1025001.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Mjx1025001.class.getSimpleName());
            }
        }
        if(clazz.equals(RecogStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RecogStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RecogStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RecogSheet.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RecogSheet.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RecogSheet.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MatchStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CooperateFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CooperateFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CooperateFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(ComplianceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ComplianceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ComplianceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RetreatStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RetreatStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RetreatStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(HangStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != HangStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, HangStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SignForStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SignForStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SignForStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeUpStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeUpStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeUpStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PaymentStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PaymentStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BlackStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BlackStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BlackStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TurnOutStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TurnOutStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TurnOutStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TurnOutType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TurnOutType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TurnOutType.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuditStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuditStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DataStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DataStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DataStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceBusinessType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceBusinessType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceBusinessType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceCategory.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceCategory.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceCategory.class.getSimpleName());
            }
        }
        if(clazz.equals(AreaType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AreaType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AreaType.class.getSimpleName());
            }
        }
        if(clazz.equals(IsCancelCheck.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsCancelCheck.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsCancelCheck.class.getSimpleName());
            }
        }
        if(clazz.equals(SaleConfirmStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SaleConfirmStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SaleConfirmStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReportStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReportStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReportStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReimbursementStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReimbursementStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReimbursementStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RedStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RedStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RedStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(EntryStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EntryStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EntryStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(EntryTabStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EntryTabStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EntryTabStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(NoComplianceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NoComplianceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NoComplianceType.class.getSimpleName());
            }
        }
        if(clazz.equals(FollowUpStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FollowUpStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FollowUpStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RiskHandleStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RiskHandleStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RiskHandleStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessControlStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BusinessControlStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BusinessControlStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(FunctionGroup.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FunctionGroup.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FunctionGroup.class.getSimpleName());
            }
        }
        if(clazz.equals(FunctionGroupWay.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FunctionGroupWay.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FunctionGroupWay.class.getSimpleName());
            }
        }
        if(clazz.equals(UnCertifiedReason.class)) {
            isValid = vals.stream()
                    .filter(val -> null != UnCertifiedReason.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, UnCertifiedReason.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceExt30.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceExt30.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceExt30.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceExt35.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceExt35.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceExt35.class.getSimpleName());
            }
        }
        if(clazz.equals(RiskInvoiceCategory.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RiskInvoiceCategory.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RiskInvoiceCategory.class.getSimpleName());
            }
        }
        if(clazz.equals(IsRepeat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsRepeat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsRepeat.class.getSimpleName());
            }
        }
        if(clazz.equals(IsNeedAuth.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsNeedAuth.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsNeedAuth.class.getSimpleName());
            }
        }
        if(clazz.equals(IsSendException.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsSendException.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsSendException.class.getSimpleName());
            }
        }
        if(clazz.equals(ReturnType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReturnType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReturnType.class.getSimpleName());
            }
        }
        if(clazz.equals(ReturnBatch.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReturnBatch.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReturnBatch.class.getSimpleName());
            }
        }
        if(clazz.equals(NeedExpress.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NeedExpress.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NeedExpress.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrgType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrgType.class.getSimpleName());
            }
        }
        if(clazz.equals(CreationMethod.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CreationMethod.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CreationMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrgStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrgStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
