package com.xforceplus.ultraman.billing.client.aspect.controller;

import com.xforceplus.ultraman.billing.client.aspect.BillingScope;
import com.xforceplus.ultraman.billing.client.remote.ResourceApi;
import com.xforceplus.ultraman.billing.domain.ResourceCreateRequest;
import com.xforceplus.ultraman.billing.domain.Response;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

import java.lang.reflect.Method;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

@RequestMapping("/utils")
public class ScanHelperController implements ApplicationContextAware {

    private ApplicationContext context;

    @Autowired
    private ResourceApi resourceApi;

    @Value("${ultraman.billing.service}")
    private List<String> serviceList;

    @GetMapping("/scan-controller")
    public ResponseEntity<Response> scanController() {

        RequestMappingHandlerMapping requestMappingHandlerMapping = context.getBeansOfType(RequestMappingHandlerMapping.class).get("requestMappingHandlerMapping");
        Map<RequestMappingInfo, HandlerMethod> handlerMethods = requestMappingHandlerMapping.getHandlerMethods();

        /**
         *  resourceCreateRequest.setName(resourceName);
         *  resourceCreateRequest.setService(scope);
         *  resourceCreateRequest.setExternalType("METHOD");
         *  resourceCreateRequest.setResourceId(resourceName);
         *  resourceCreateRequest.setExternalResource(method.getDeclaringClass().getName().concat("#").concat(method.getName()));
         *  resourceCreateRequest.setUri("res://".concat("oqs/").concat(scope).concat("/").concat(resourceName));
         *  resourceCreateRequest.setDescription(method.toGenericString());
         *  resourceCreateRequest.setType("cap");
         */

        List<ResourceCreateRequest> request = handlerMethods.entrySet().stream()
                .flatMap(entry -> {
                    RequestMappingInfo info = entry.getKey();
                    HandlerMethod value = entry.getValue();
                    Set<String> directPaths = info.getDirectPaths();
                    RequestMethodsRequestCondition methodsCondition = info.getMethodsCondition();
                    Set<RequestMethod> methods = methodsCondition.getMethods();
                    return methods.stream().flatMap(m -> {
                        AtomicInteger index = new AtomicInteger(0);
                        return directPaths.stream().map(p -> {
                            String resourceName = "";
                            String clzName = value.getMethod().getDeclaringClass().getSimpleName().toLowerCase();
                            String methodName = value.getMethod().getName();
                            if (index.get() == 0) {
                                resourceName = clzName.concat("-").concat(methodName);
                            } else {
                                resourceName = clzName.concat("-").concat(methodName).concat("-").concat(Integer.toString(index.get()));
                            }

                            index.getAndIncrement();
                            ResourceCreateRequest r = new ResourceCreateRequest();
                            r.setService(serviceList.get(0));
                            r.setType("cap");
                            r.setExternalType("HTTP");
                            r.setDescription(info.toString());
                            r.setName(resourceName);
                            r.setResourceId(resourceName);
                            r.setUri("res://".concat(serviceList.get(0)).concat("/")
                                            .concat(value.getMethod().getDeclaringClass().getSimpleName())
                                            .concat("/")
                                            .concat(value.getMethod().getName())
                            );
                            r.setExternalResource(m.name().concat(" ").concat(p));

                            return r;
                        });
                    });
                }).collect(Collectors.toList());

        Response response;
        if (!request.isEmpty()) {
            response = resourceApi.batchCreateResource(request);
        } else {
            response = new Response();
            response.setCode("1");
            response.setMessage("操作成功");
        }

        return ResponseEntity.ok(response);
    }

    @GetMapping("/scan-method")
    public ResponseEntity<Response> scanMethod() {
        String[] beanDefinitionNames = context.getBeanDefinitionNames();
        Map<String, List<Method>> methodMapping = new HashMap<>();
        for (String beanName : beanDefinitionNames) {
            try {
                Object bean = context.getBean(beanName);
                Class<?> beanClass = AopUtils.getTargetClass(bean);
                BillingScope[] billingScope = beanClass.getAnnotationsByType(BillingScope.class);
                if (billingScope != null) {
                    BillingScope billingScope1 = billingScope[0];
                    Method[] declaredMethods = beanClass.getMethods();
                    methodMapping.compute(billingScope1.value(), (k, v) -> {
                        if (v == null) {
                            v = new ArrayList<>();
                        }
                        Collections.addAll(v, declaredMethods);
                        return v;
                    });

                } else {
                    // Check if the class has any methods annotated with @Intercept
                    for (Method method : beanClass.getDeclaredMethods()) {
                        if (method.isAnnotationPresent(BillingScope.class)) {
                            // Save method information to the database
                            BillingScope declaredAnnotation = method.getDeclaredAnnotation(BillingScope.class);
                            if (declaredAnnotation != null) {
                                methodMapping.compute(declaredAnnotation.value(), (k, v) -> {
                                    if (v == null) {
                                        v = new ArrayList<>();
                                    }
                                    v.add(method);
                                    return v;
                                });
                            }
                        }
                    }
                }
            } catch (Throwable throwable) {
                //do nothing
            }
        }

        List<ResourceCreateRequest> request = methodMapping.entrySet().stream()
                .flatMap(entry -> {
                    String key = entry.getKey();
                    List<Method> value = entry.getValue();
                    return value.stream().map(method -> {
                        return toResource(key, method);
                    });
                }).collect(Collectors.toList());

        Response response;
        if (!request.isEmpty()) {
            response = resourceApi.batchCreateResource(request);
        } else {
            response = new Response();
            response.setCode("1");
            response.setMessage("操作成功");
        }


        return ResponseEntity.ok(response);
    }

    private ResourceCreateRequest toResource(String scope, Method method) {
        ResourceCreateRequest resourceCreateRequest = new ResourceCreateRequest();
        String resourceName = method.getDeclaringClass().getSimpleName().concat("-").concat(method.getName()).toLowerCase();
        resourceCreateRequest.setName(resourceName);
        resourceCreateRequest.setService(scope);
        resourceCreateRequest.setExternalType("METHOD");
        resourceCreateRequest.setResourceId(resourceName);
        resourceCreateRequest.setExternalResource(method.getDeclaringClass().getName().concat("#").concat(method.getName()));
        resourceCreateRequest.setUri("res://".concat("oqs/").concat(scope).concat("/").concat(resourceName));
        resourceCreateRequest.setDescription(method.toGenericString());
        resourceCreateRequest.setType("cap");

        return resourceCreateRequest;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}
