package com.xforceplus.ultraman.billing.client.impl;

import com.xforceplus.ultraman.billing.client.UsageLifecycle;
import com.xforceplus.ultraman.billing.client.dto.UsageResponse;
import com.xforceplus.ultraman.billing.client.remote.UsageApi;
import com.xforceplus.ultraman.billing.domain.ListUsageRequest;
import com.xforceplus.ultraman.billing.domain.ResourceCreateRequest;
import com.xforceplus.ultraman.billing.domain.Usage;
import com.xforceplus.ultraman.billing.domain.UsageRule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class DefaultUsageLifecycle implements UsageLifecycle {

    @Value("${ultraman.billing.service}")
    private List<String> serviceList;

    @Autowired
    private UsageApi usageApi;

    @Override
    public UsageMatchedContext matchedUsage(Supplier<String> teamCodeSupplier, Predicate<ResourceCreateRequest> filter) {
        String teamCode = teamCodeSupplier.get();
        ListUsageRequest listUsageRequest = new ListUsageRequest();
        listUsageRequest.setService(serviceList);
        listUsageRequest.setTenant(teamCode);
        UsageResponse allUsages = usageApi.getAllUsages(listUsageRequest);
        UsageMatchedContext usageMatchedContext = new UsageMatchedContext();
        if (allUsages.getCode().equalsIgnoreCase("1")) {
            List<Usage> usageList = allUsages.getResult();
            if (usageList != null) {
                usageList.forEach(usage -> {
                    ResourceCreateRequest resourceRef = usage.getResourceRef();
                    if (resourceRef != null) {
                        if (filter.test(resourceRef)) {
                            usageMatchedContext.accept(usage, resourceRef);
                        }
                    } else if (usage.getRules() != null && !usage.getRules().isEmpty()) {
                        List<UsageRule> rules = usage.getRules();
                        rules.stream().filter(x -> x.getResourceRef() != null).forEach(x -> {
                            ResourceCreateRequest relatedResource = x.getResourceRef();
                            if(filter.test(relatedResource)) {
                                usageMatchedContext.accept(usage, x);
                            }
                        });
                    }
                });
            }
        }
        return usageMatchedContext;
    }
}
