package com.xforceplus.ultraman.billing.client.impl;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.xforceplus.ultraman.billing.client.LicenceService;
import com.xforceplus.ultraman.billing.client.remote.BillingApi;
import com.xforceplus.ultraman.billing.domain.CheckResponse;
import com.xforceplus.ultraman.billing.domain.LicenceRequest;
import com.xforceplus.ultraman.billing.domain.LicenceResource;
import com.xforceplus.ultraman.billing.domain.LicenceResponse;
import com.xforceplus.ultraman.bocp.uc.context.UcUserInfoHolder;
import com.xforceplus.ultraman.bocp.uc.pojo.auth.UcAuthUser;
import io.github.jamsesso.jsonlogic.JsonLogic;
import io.github.jamsesso.jsonlogic.JsonLogicException;
import org.springframework.beans.factory.annotation.Autowired;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class LicenceServiceImpl implements LicenceService {
   
    @Autowired
    private BillingApi billingApi;

    private LoadingCache<LicenceRequest, LicenceResponse> licenceCaches;

    public LicenceServiceImpl() {
        licenceCaches = Caffeine.newBuilder()
                .maximumSize(1000)
                .expireAfterWrite(Duration.ofMinutes(10))
                .build(x -> {
                    LicenceResponse licenceResponse = billingApi.fetchLicence(x);
                    if(licenceResponse.getCode() == 1) {
                        return licenceResponse;
                    } else {
                        return null;
                    }
                });
        
    }

    @Override
    public CheckResponse checkResource(String identity, List<Object> inputParams) {
        
        //TODO cache
        LicenceRequest licenceRequest = new LicenceRequest();
        UcAuthUser ucAuthUser = UcUserInfoHolder.get();
        CheckResponse checkResponse = new CheckResponse();
        if(ucAuthUser != null) {
            licenceRequest.setUser(ucAuthUser.getAccountId().toString());
            LicenceResponse licenceResponse = licenceCaches.get(licenceRequest);
            if(licenceResponse != null && licenceResponse.getCode() == 1) {
                List<LicenceResource> resources = licenceResponse.getResources();
                Optional<LicenceResource> targetResourceRule = resources.stream().filter(x -> isIdentity(x, identity)).findAny();
                if(targetResourceRule.isPresent()) {
                    LicenceResource licenceResource = targetResourceRule.get();
                    List<String> params = licenceResource.getParams();
                    boolean isPassed = checkParams(licenceResource, inputParams);
                    if(isPassed) {
                        checkResponse.setCode(1);
                    } else {
                        checkResponse.setCode(-1);
                        checkResponse.setMessageCode(licenceResource.getMessageCode());
                        checkResponse.setDefaultMessage(licenceResource.getDefaultMessage());
                    }
                } 
            }

            return checkResponse;
        } else {
            return null;
        }
    }
    
    private boolean isIdentity(LicenceResource src, String target) {
        return src.getResourceId().equalsIgnoreCase(target);
    }
    
    private boolean checkParams(LicenceResource src, List<Object> inputParams)  {
        Map<String, Object> variable = new HashMap<>();
//        providerList.stream().filter(x -> x.getResourceId().equalsIgnoreCase(src.getResourceId())).forEach(x -> {
//            x.eval(src.getParams(), variable, inputParams);
//        });

        String expression = src.getExpression();
        JsonLogic jsonLogic = new JsonLogic();
        boolean result = false;
        try {
            result = (boolean) jsonLogic.apply(expression, variable);
            return result;
        } catch (JsonLogicException e) {
           return false;
        }
    }
}
