package com.xforceplus.ultraman.billing.client.impl;

import com.xforceplus.ultraman.billing.domain.ResourceCreateRequest;
import com.xforceplus.ultraman.billing.domain.Usage;
import com.xforceplus.ultraman.billing.domain.UsageRule;

import java.util.*;
import java.util.stream.Collectors;

//TODO
public class UsageMatchedContext {


    private Map<String, List<String>> sourceIdMapping = new HashMap<>();
    private Map<String, Usage> usageIdMapping = new HashMap<>();

    private Map<String, UsageRule> usageRuleIdMapping = new HashMap<>();
    
    private Map<String, Usage> ruleIdUsageMapping = new HashMap<>();


    public Map<String, List<String>> getSourceIdMapping() {
        return sourceIdMapping;
    }

    public Map<String, Usage> getUsageIdMapping() {
        return usageIdMapping;
    }
    
    /**
     * build usage and resource
     * @param usage
     * @param resource
     */
    public void accept(Usage usage, ResourceCreateRequest resource) {
        //cache usage
        usageIdMapping.put(usage.getId(), usage);
        String externalResource = resource.getExternalResource();
        sourceIdMapping.compute(externalResource, (k, v) -> {
            if (v == null) {
                v = new ArrayList<>();
            }

            v.add(usage.getId());
            return v;
        });
    }

    public void accept(Usage usage, UsageRule rule) {
        //cache usage
        usageIdMapping.put(usage.getId(), usage);
        usageRuleIdMapping.put(rule.getId().toString(), rule);
        ruleIdUsageMapping.put(rule.getId().toString(), usage);
        ResourceCreateRequest resourceRef = rule.getResourceRef();
        if(resourceRef != null) {
            String externalResource = resourceRef.getExternalResource();
            sourceIdMapping.compute(externalResource, (k, v) -> {
                if (v == null) {
                    v = new ArrayList<>();
                }

                /**
                 * rule id
                 */
                v.add("rule-".concat(rule.getId().toString()));
                return v;
            });
        }
    }

    public Collection<? extends Usage> findUsagesByIds(String[] ids) {
        return Arrays.stream(ids).map(id -> usageIdMapping.get(id))
                .filter(Objects::nonNull)
                .collect(Collectors.toList());
    }

    public UsageRule getUsageRuleById(String idToken) {
        return usageRuleIdMapping.get(idToken);
    }

    public Usage getUsageById(String idToken) {
        return usageIdMapping.get(idToken);
    }

    public Usage getUsageByRuleId(String idToken) {
        return ruleIdUsageMapping.get(idToken);
    }
}
