package com.xforceplus.ultraman.billing.client.remote;

import com.xforceplus.ultraman.billing.client.dto.UsageResponse;
import com.xforceplus.ultraman.billing.domain.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;


@FeignClient(
        name = "usage-client",
        url = "${ultraman.billing.url:localhost:8080}"
)
public interface UsageApi {

    @PostMapping("/billing/v1/usage/list")
    UsageResponse getAllUsages(@RequestBody ListUsageRequest listUsageRequest);

    @PostMapping("/billing/v1/usage/check")
    Response checkUsage(@RequestBody CheckUsageRequest usage);

    @PostMapping("/billing/v1/usage/record")
    Response record(@RequestBody UsageRequest usageRequest);
    
    @PostMapping("/billing/v1/usage/rollback")
    Response rollback(@RequestBody RollbackRequest request);
    
}
