package com.xforceplus.ultraman.billing.client.utils;

import org.apache.commons.io.output.TeeOutputStream;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;

/**
 * TODO
 */
public class CachedBodyHttpServletResponse extends HttpServletResponseWrapper {

    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private final PrintStream ps = new PrintStream(baos);

    public CachedBodyHttpServletResponse(HttpServletResponse response) {
        super(response);
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        return new CachedBodyServletOutputStream(new TeeOutputStream(super.getOutputStream(), ps));
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        return new PrintWriter(new CachedBodyServletOutputStream (new TeeOutputStream(super.getOutputStream(), ps)));
    }

    public String getResponseBody() {
        return baos.toString();
    }
}
