package com.xforceplus.ultraman.billing.client.utils;


import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class CachedBodyServletInputStream extends ServletInputStream {

    private final
    InputStream cachedBodyInputStream;

    public CachedBodyServletInputStream(final byte[] cachedBody) {
        this.cachedBodyInputStream = new ByteArrayInputStream(cachedBody);
    }

    @Override
    @SuppressWarnings("EmptyCatch")
    public boolean isFinished() {
        try {
            return cachedBodyInputStream.available() == 0;
        } catch (IOException e) {
        }
        return false;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void setReadListener(final ReadListener readListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read() throws IOException {
        return cachedBodyInputStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return cachedBodyInputStream.read(b, off, len);
    }
}