package com.xforceplus.ultraman.billing.client.utils;

import java.util.HashMap;
import java.util.Map;

public class ExtractUtils {

    public static Map<String, String> extractKeyValueMapping(String urlPattern, String url) {
        Map<String, String> keyValueMap = new HashMap<>();

        // Split the URL pattern and URL by '/'
        String[] patternParts = urlPattern.split("/");
        String[] urlParts = url.split("/");

        // Iterate through each part and check if it's a placeholder or a value
        for (int i = 0; i < patternParts.length; i++) {
            String patternPart = patternParts[i];
            String urlPart = urlParts[i];

            // If the pattern part is a placeholder, extract the corresponding value
            if (patternPart.startsWith("{") && patternPart.endsWith("}")) {
                String key = patternPart.substring(1, patternPart.length() - 1);
                String value = urlPart;
                keyValueMap.put(key, value);
            }
        }

        return keyValueMap;
    }
}
