package com.xforceplus.ultraman.billing.client.utils;

import org.springframework.util.StreamUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public final class HttpPayloadExtractor implements PayloadExtractor {

    @Override
    public String extract(final HttpServletRequest request) {
        if (request instanceof CachedBodyHttpServletRequest) {
            try {
                final byte[] body = StreamUtils.copyToByteArray(request.getInputStream());
                return new String(body, StandardCharsets.UTF_8);
            } catch (IOException e) {
                return null;
            }
        } else {
            return null;
        }
    }

    @Override
    public String extract(final HttpServletResponse response) {
        if (response instanceof CachedBodyHttpServletResponse)
            try {
                return ((CachedBodyHttpServletResponse) response).getResponseBody();
            } catch (Exception e) {
                e.printStackTrace();
            }
        return "";
    }
}
