/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.billing.client.aspect;

import com.xforceplus.ultraman.billing.client.UsageLifecycle;
import com.xforceplus.ultraman.billing.client.aspect.TeamCodeSupplier;
import com.xforceplus.ultraman.billing.client.impl.UsageMatchedContext;
import com.xforceplus.ultraman.billing.client.remote.UsageApi;
import com.xforceplus.ultraman.billing.domain.CheckUsageRequest;
import com.xforceplus.ultraman.billing.domain.Response;
import com.xforceplus.ultraman.billing.domain.RollbackRequest;
import com.xforceplus.ultraman.billing.domain.Usage;
import com.xforceplus.ultraman.billing.domain.UsageRequest;
import com.xforceplus.ultraman.billing.domain.UsageRule;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Tuple5;
import io.vavr.control.Either;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@Aspect
public class BillingAspect {
    private static final Logger log = LoggerFactory.getLogger(BillingAspect.class);
    private TeamCodeSupplier teamCodeSupplier;
    private List<String> serviceTokens;
    private UsageApi usageApi;
    @Autowired
    private UsageLifecycle usageLifecycle;
    @Autowired
    private Supplier<String> appCodeSupplier;

    public BillingAspect(TeamCodeSupplier teamCodeSupplier, Supplier<String> appCodeSupplier, UsageApi usageApi, String serviceTokens) {
        this.teamCodeSupplier = teamCodeSupplier;
        this.usageApi = usageApi;
        this.serviceTokens = Arrays.asList(serviceTokens.split(","));
        this.appCodeSupplier = appCodeSupplier;
    }

    private void rollback(Map<String, String> preFetchIdMapping) {
        try {
            if (!preFetchIdMapping.isEmpty()) {
                Collection<String> values = preFetchIdMapping.values();
                RollbackRequest rollbackRequest = new RollbackRequest();
                rollbackRequest.setPrefetchIds(new ArrayList<String>(values));
                this.usageApi.rollback(rollbackRequest);
            }
        }
        catch (Throwable throwable) {
            log.warn("", throwable);
        }
    }

    @Around(value="(@within(com.xforceplus.ultraman.billing.client.aspect.BillingScope) && execution(public * *(..))) || @annotation(com.xforceplus.ultraman.billing.client.aspect.BillingScope)")
    public Object transactionExecution(ProceedingJoinPoint pjp) throws Throwable {
        UsageMatchedContext usageMatchedContext = null;
        ArrayList<Tuple5<Tuple2<Usage, UsageRule>, String, String, Response, Integer>> passedUsageList = new ArrayList<Tuple5<Tuple2<Usage, UsageRule>, String, String, Response, Integer>>();
        HashMap<String, String> preFetchIdMapping = new HashMap<String, String>();
        try {
            usageMatchedContext = this.usageLifecycle.matchedUsage(this.teamCodeSupplier, x -> x.getExternalType().equalsIgnoreCase("METHOD"));
        }
        catch (Throwable throwable) {
            log.error("", throwable);
        }
        String teamCode = (String)this.teamCodeSupplier.get();
        if (usageMatchedContext != null) {
            List<Either<Usage, UsageRule>> targetUsages = this.matchUsage(usageMatchedContext, pjp);
            for (Either<Usage, UsageRule> either : targetUsages) {
                Tuple5<Tuple2<Usage, UsageRule>, String, String, Response, Integer> tuple5 = this.usageProcess(pjp, usageMatchedContext, either, teamCode, preFetchIdMapping);
                if (tuple5 == null) continue;
                if ((Integer)tuple5._5 < 0) {
                    this.rollback(preFetchIdMapping);
                    throw new RuntimeException(((Response)tuple5._4).getMessage());
                }
                passedUsageList.add(tuple5);
            }
        }
        ArrayList callbacks = new ArrayList();
        Object proceedResult = pjp.proceed();
        for (Tuple5 tuple5 : passedUsageList) {
            if (tuple5 == null) continue;
            try {
                Object contextMap;
                HashMap<String, String> keySizeMap = new HashMap<String, String>();
                String targetKey = (String)tuple5._2;
                String targetSize = (String)tuple5._3;
                boolean inCB = false;
                keySizeMap.put("key", targetKey);
                keySizeMap.put("size", targetSize);
                UsageRequest usageRequest = new UsageRequest();
                usageRequest.setUsage(((Usage)((Tuple2)tuple5._1)._1).getName());
                usageRequest.setPreFetchId((String)preFetchIdMapping.get(((Usage)((Tuple2)tuple5._1)._1).getId()));
                String keyExpr = null;
                String sizeExpr = null;
                if (keySizeMap.get("key") == null) {
                    String string = keyExpr = ((Usage)((Tuple2)tuple5._1)._1).getKeyExpr() == null ? ((UsageRule)((Tuple2)tuple5._1)._2).getKeyExpr() : ((Usage)((Tuple2)tuple5._1)._1).getKeyExpr();
                    if (keyExpr.startsWith("CALLBACK:") && proceedResult instanceof CompletionStage) {
                        keyExpr = keyExpr.substring(9);
                        inCB = true;
                    } else if (keyExpr.startsWith("RETURN:")) {
                        contextMap = new HashMap();
                        contextMap.put("root", proceedResult);
                        keyExpr = keyExpr.substring(7);
                        String evaluatedKey = this.evaluate(keyExpr, String.class, (Map<String, Object>)contextMap);
                        keySizeMap.put("key", evaluatedKey);
                    }
                }
                if (keySizeMap.get("size") == null) {
                    String string = sizeExpr = ((Usage)((Tuple2)tuple5._1)._1).getSizeExpr() == null ? ((UsageRule)((Tuple2)tuple5._1)._2).getSizeExpr() : ((Usage)((Tuple2)tuple5._1)._1).getSizeExpr();
                    if (sizeExpr.startsWith("CALLBACK:") && proceedResult instanceof CompletionStage) {
                        sizeExpr = sizeExpr.substring(9);
                        inCB = true;
                    } else if (sizeExpr.startsWith("RETURN:")) {
                        contextMap = new HashMap();
                        contextMap.put("root", proceedResult);
                        sizeExpr = sizeExpr.substring(7);
                        String evaluatedSize = this.evaluate(sizeExpr, String.class, (Map<String, Object>)contextMap);
                        keySizeMap.put("size", evaluatedSize);
                    }
                }
                if (!inCB) {
                    usageRequest.setKey((String)keySizeMap.get("key"));
                    usageRequest.setSize((String)keySizeMap.get("size"));
                    usageRequest.setTenant(teamCode);
                    contextMap = this.usageApi.record(usageRequest);
                    continue;
                }
                String finalKeyExpr = keyExpr;
                String finalSizeExpr = sizeExpr;
                ((CompletionStage)proceedResult).thenApply(x -> {
                    try {
                        HashMap<String, Object> context;
                        String targetKeyInCB = (String)keySizeMap.get("key");
                        String targetSizeInCB = (String)keySizeMap.get("size");
                        if (finalKeyExpr != null && targetKeyInCB == null) {
                            context = new HashMap<String, Object>();
                            context.put("root", x);
                            targetKeyInCB = this.evaluate(finalKeyExpr, String.class, context);
                        }
                        if (finalSizeExpr != null && targetSizeInCB == null) {
                            context = new HashMap();
                            context.put("root", x);
                            targetSizeInCB = this.evaluate(finalSizeExpr, String.class, context);
                        }
                        usageRequest.setKey(targetKeyInCB);
                        usageRequest.setSize(targetSizeInCB);
                        usageRequest.setTenant(teamCode);
                        Response response = this.usageApi.record(usageRequest);
                    }
                    catch (Throwable throwable) {
                        log.error("", throwable);
                    }
                    return x;
                });
            }
            catch (Throwable throwable) {
                log.error("", throwable);
            }
        }
        return proceedResult;
    }

    private String renderExpr(String expression, Map<String, Object> templateBinding) {
        for (Map.Entry<String, Object> entry : templateBinding.entrySet()) {
            String k = entry.getKey();
            Object v = entry.getValue();
            if (!expression.contains("{{".concat(k).concat("}}"))) continue;
            expression = expression.replaceAll("\\{\\{".concat(k).concat("\\}\\}"), v.toString());
        }
        return expression;
    }

    private Tuple5<Tuple2<Usage, UsageRule>, String, String, Response, Integer> usageProcess(ProceedingJoinPoint pjp, UsageMatchedContext usageMatchedContext, Either<Usage, UsageRule> targetUsage, String teamCode, Map<String, String> mapping) {
        Object targetSize;
        int i;
        Object[] args;
        HashMap<String, Object> params;
        Object[] args2;
        HashMap<String, Object> vars;
        String limitationExpr = null;
        String dryRunSizeExpr = null;
        String validateExpr = null;
        String keyExpr = null;
        String sizeExpr = null;
        String filterExpr = null;
        String targetKey = null;
        Object size = null;
        Usage retUsage = null;
        UsageRule retRule = null;
        if (targetUsage.isLeft()) {
            Usage targetUsageLeft = (Usage)targetUsage.getLeft();
            limitationExpr = targetUsageLeft.getLimitation();
            dryRunSizeExpr = targetUsageLeft.getDryRunSizeExpr();
            validateExpr = targetUsageLeft.getLimitationExpr();
            sizeExpr = targetUsageLeft.getSizeExpr();
            keyExpr = targetUsageLeft.getKeyExpr();
            retUsage = targetUsageLeft;
        } else {
            UsageRule usageRule = (UsageRule)targetUsage.get();
            Usage usageByRuleId = usageMatchedContext.getUsageByRuleId(usageRule.getId().toString());
            Map templateBinding = Optional.ofNullable(usageByRuleId.getTemplateBinding()).orElseGet(Collections::emptyMap);
            HashMap<String, Object> finalTemplateBinding = new HashMap<String, Object>(templateBinding);
            finalTemplateBinding.put("appCode", this.appCodeSupplier.get());
            limitationExpr = usageByRuleId.getLimitation();
            dryRunSizeExpr = usageRule.getDryRunSizeExpr() == null ? null : this.renderExpr(usageRule.getDryRunSizeExpr(), finalTemplateBinding);
            validateExpr = usageRule.getValidateExpr() == null ? null : this.renderExpr(usageRule.getValidateExpr(), finalTemplateBinding);
            sizeExpr = usageRule.getSizeExpr() == null ? null : this.renderExpr(usageRule.getSizeExpr(), finalTemplateBinding);
            keyExpr = usageRule.getKeyExpr() == null ? null : this.renderExpr(usageRule.getKeyExpr(), finalTemplateBinding);
            filterExpr = usageRule.getFilterExpr() == null ? null : this.renderExpr(usageRule.getFilterExpr(), finalTemplateBinding);
            retUsage = usageByRuleId;
            retRule = usageRule;
        }
        if (!StringUtils.isEmpty(filterExpr)) {
            Boolean matched;
            vars = new HashMap<String, Object>();
            if (filterExpr.startsWith("PARAMS:")) {
                filterExpr = filterExpr.substring(7);
                HashMap<String, Object> params2 = new HashMap<String, Object>();
                args2 = pjp.getArgs();
                for (int i2 = 0; i2 < args2.length; ++i2) {
                    params2.put(Integer.toString(i2), args2[i2]);
                }
                vars.putAll(params2);
            }
            if (!(matched = this.evaluate(filterExpr, Boolean.class, vars)).booleanValue()) {
                return null;
            }
        }
        if (StringUtils.isEmpty((CharSequence)keyExpr)) {
            targetKey = "default";
        } else {
            vars = new HashMap();
            boolean skipEvaluation = false;
            if (keyExpr.startsWith("PARAMS:")) {
                keyExpr = keyExpr.substring(7);
                params = new HashMap<String, Object>();
                args = pjp.getArgs();
                for (i = 0; i < args.length; ++i) {
                    params.put(Integer.toString(i), args[i]);
                }
                vars.putAll(params);
            } else {
                skipEvaluation = true;
            }
            if (!skipEvaluation) {
                targetKey = this.evaluate(keyExpr, String.class, vars);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)validateExpr)) {
            vars = new HashMap();
            if (validateExpr.startsWith("PARAMS:")) {
                validateExpr = validateExpr.substring(7);
                Boolean isPassed = true;
                params = new HashMap();
                args = pjp.getArgs();
                for (i = 0; i < args.length; ++i) {
                    params.put(Integer.toString(i), args[i]);
                }
                vars.putAll(params);
                isPassed = this.evaluate(validateExpr, Boolean.class, vars);
                if (!isPassed.booleanValue()) {
                    Response overResp = new Response();
                    overResp.setCode("-1");
                    overResp.setMessage(((Usage)targetUsage.getLeft()).getErrorMsg());
                    return Tuple.of((Object)Tuple.of((Object)retUsage, (Object)retRule), null, null, (Object)overResp, (Object)-1);
                }
            }
        }
        if (!StringUtils.isEmpty((CharSequence)limitationExpr)) {
            CheckUsageRequest checkUsageRequest = new CheckUsageRequest();
            if (!StringUtils.isEmpty((CharSequence)dryRunSizeExpr) && dryRunSizeExpr.startsWith("PARAMS:")) {
                dryRunSizeExpr = dryRunSizeExpr.substring(7);
                HashMap<String, Object> params3 = new HashMap<String, Object>();
                args2 = pjp.getArgs();
                for (int i3 = 0; i3 < args2.length; ++i3) {
                    params3.put(Integer.toString(i3), args2[i3]);
                }
                String dryRunSize = this.evaluate(dryRunSizeExpr, String.class, params3);
                checkUsageRequest.setDryRunValue(dryRunSize);
            }
            if (checkUsageRequest.getDryRunValue() == null) {
                checkUsageRequest.setDryRunValue("1");
            }
            checkUsageRequest.setUsage(retUsage);
            checkUsageRequest.setTenant(teamCode);
            checkUsageRequest.setRecordKey(targetKey);
            checkUsageRequest.setPreFetch(Boolean.valueOf(true));
            Response checkUsage = this.usageApi.checkUsage(checkUsageRequest);
            if (!"1".equalsIgnoreCase(checkUsage.getCode())) {
                return Tuple.of((Object)Tuple.of((Object)retUsage, (Object)retRule), null, null, (Object)checkUsage, (Object)-1);
            }
            if (checkUsage.getResult() != null) {
                mapping.put(retUsage.getId(), checkUsage.getResult().toString());
            }
        }
        if (StringUtils.isEmpty((CharSequence)sizeExpr)) {
            targetSize = "1";
        } else {
            HashMap<String, Object> vars2 = new HashMap<String, Object>();
            boolean skipEvaluation = false;
            if (sizeExpr.startsWith("PARAMS:")) {
                sizeExpr = sizeExpr.substring(7);
                HashMap<String, Object> params4 = new HashMap<String, Object>();
                Object[] args3 = pjp.getArgs();
                for (int i4 = 0; i4 < args3.length; ++i4) {
                    params4.put(Integer.toString(i4), args3[i4]);
                }
                vars2.put("root", params4);
            } else {
                skipEvaluation = true;
            }
            targetSize = !skipEvaluation ? this.evaluate(sizeExpr, String.class, vars2) : (sizeExpr.startsWith("CALLBACK:") ? null : sizeExpr);
        }
        return Tuple.of((Object)Tuple.of((Object)retUsage, retRule), (Object)targetKey, (Object)targetSize, null, (Object)1);
    }

    private List<Either<Usage, UsageRule>> matchUsage(UsageMatchedContext usageMatchedContext, ProceedingJoinPoint pjp) {
        Signature signature = pjp.getSignature();
        String targetResource = signature.getDeclaringTypeName().concat("#").concat(signature.getName());
        ArrayList<Either<Usage, UsageRule>> retList = new ArrayList<Either<Usage, UsageRule>>();
        usageMatchedContext.getUsageIdMapping().values().forEach(v -> {
            if (v.getResourceRef() != null) {
                if (v.getResourceRef().getExternalResource().equalsIgnoreCase(targetResource)) {
                    retList.add(Either.left((Object)v));
                }
            } else {
                List rules = v.getRules();
                if (rules != null && !rules.isEmpty()) {
                    rules.forEach(r -> {
                        if (r.getResourceRef() != null && r.getResourceRef().getExternalResource().equalsIgnoreCase(targetResource)) {
                            retList.add(Either.right((Object)r));
                        }
                    });
                }
            }
        });
        return retList;
    }

    private <T> T evaluate(String keyExpr, Class<T> clz, Map<String, Object> varMapping) {
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext ec = new StandardEvaluationContext(varMapping);
        Expression expression = parser.parseExpression(keyExpr);
        Object result = expression.getValue((EvaluationContext)ec, clz);
        return (T)result;
    }
}

