/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.billing.client.aspect.controller;

import com.xforceplus.ultraman.billing.client.aspect.BillingScope;
import com.xforceplus.ultraman.billing.client.remote.ResourceApi;
import com.xforceplus.ultraman.billing.domain.ResourceCreateRequest;
import com.xforceplus.ultraman.billing.domain.Response;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@RequestMapping(value={"/utils"})
public class ScanHelperController
implements ApplicationContextAware {
    private ApplicationContext context;
    @Autowired
    private ResourceApi resourceApi;
    @Value(value="${ultraman.billing.service}")
    private List<String> serviceList;

    @GetMapping(value={"/scan-controller"})
    public ResponseEntity<Response> scanController() {
        Response response;
        RequestMappingHandlerMapping requestMappingHandlerMapping = (RequestMappingHandlerMapping)this.context.getBeansOfType(RequestMappingHandlerMapping.class).get("requestMappingHandlerMapping");
        Map handlerMethods = requestMappingHandlerMapping.getHandlerMethods();
        List<ResourceCreateRequest> request = handlerMethods.entrySet().stream().flatMap(entry -> {
            RequestMappingInfo info = (RequestMappingInfo)entry.getKey();
            HandlerMethod value = (HandlerMethod)entry.getValue();
            Set directPaths = info.getDirectPaths();
            RequestMethodsRequestCondition methodsCondition = info.getMethodsCondition();
            Set methods = methodsCondition.getMethods();
            return methods.stream().flatMap(m -> {
                AtomicInteger index = new AtomicInteger(0);
                return directPaths.stream().map(p -> {
                    String resourceName = "";
                    String clzName = value.getMethod().getDeclaringClass().getSimpleName().toLowerCase();
                    String methodName = value.getMethod().getName();
                    resourceName = index.get() == 0 ? clzName.concat("-").concat(methodName) : clzName.concat("-").concat(methodName).concat("-").concat(Integer.toString(index.get()));
                    index.getAndIncrement();
                    ResourceCreateRequest r = new ResourceCreateRequest();
                    r.setService(this.serviceList.get(0));
                    r.setType("cap");
                    r.setExternalType("HTTP");
                    r.setDescription(info.toString());
                    r.setName(resourceName);
                    r.setResourceId(resourceName);
                    r.setUri("res://".concat(this.serviceList.get(0)).concat("/").concat(value.getMethod().getDeclaringClass().getSimpleName()).concat("/").concat(value.getMethod().getName()));
                    r.setExternalResource(m.name().concat(" ").concat((String)p));
                    return r;
                });
            });
        }).collect(Collectors.toList());
        if (!request.isEmpty()) {
            response = this.resourceApi.batchCreateResource(request);
        } else {
            response = new Response();
            response.setCode("1");
            response.setMessage("\u64cd\u4f5c\u6210\u529f");
        }
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/scan-method"})
    public ResponseEntity<Response> scanMethod() {
        Response response;
        String[] beanDefinitionNames = this.context.getBeanDefinitionNames();
        HashMap<String, List> methodMapping = new HashMap<String, List>();
        for (String beanName : beanDefinitionNames) {
            try {
                Object bean = this.context.getBean(beanName);
                Class beanClass = AopUtils.getTargetClass((Object)bean);
                BillingScope[] billingScope = (BillingScope[])beanClass.getAnnotationsByType(BillingScope.class);
                if (billingScope != null) {
                    BillingScope billingScope1 = billingScope[0];
                    Method[] declaredMethods = beanClass.getMethods();
                    methodMapping.compute(billingScope1.value(), (k, v) -> {
                        if (v == null) {
                            v = new ArrayList();
                        }
                        Collections.addAll(v, declaredMethods);
                        return v;
                    });
                    continue;
                }
                for (Method method : beanClass.getDeclaredMethods()) {
                    BillingScope declaredAnnotation;
                    if (!method.isAnnotationPresent(BillingScope.class) || (declaredAnnotation = method.getDeclaredAnnotation(BillingScope.class)) == null) continue;
                    methodMapping.compute(declaredAnnotation.value(), (k, v) -> {
                        if (v == null) {
                            v = new ArrayList<Method>();
                        }
                        v.add(method);
                        return v;
                    });
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        List<ResourceCreateRequest> request = methodMapping.entrySet().stream().flatMap(entry -> {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            return value.stream().map(method -> this.toResource(key, (Method)method));
        }).collect(Collectors.toList());
        if (!request.isEmpty()) {
            response = this.resourceApi.batchCreateResource(request);
        } else {
            response = new Response();
            response.setCode("1");
            response.setMessage("\u64cd\u4f5c\u6210\u529f");
        }
        return ResponseEntity.ok((Object)response);
    }

    private ResourceCreateRequest toResource(String scope, Method method) {
        ResourceCreateRequest resourceCreateRequest = new ResourceCreateRequest();
        String resourceName = method.getDeclaringClass().getSimpleName().concat("-").concat(method.getName()).toLowerCase();
        resourceCreateRequest.setName(resourceName);
        resourceCreateRequest.setService(scope);
        resourceCreateRequest.setExternalType("METHOD");
        resourceCreateRequest.setResourceId(resourceName);
        resourceCreateRequest.setExternalResource(method.getDeclaringClass().getName().concat("#").concat(method.getName()));
        resourceCreateRequest.setUri("res://".concat("oqs/").concat(scope).concat("/").concat(resourceName));
        resourceCreateRequest.setDescription(method.toGenericString());
        resourceCreateRequest.setType("cap");
        return resourceCreateRequest;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

