/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.billing.client.config;

import com.xforceplus.ultraman.billing.client.UsageLifecycle;
import com.xforceplus.ultraman.billing.client.aspect.AppCodeSupplier;
import com.xforceplus.ultraman.billing.client.aspect.BillingAspect;
import com.xforceplus.ultraman.billing.client.aspect.TeamCodeSupplier;
import com.xforceplus.ultraman.billing.client.aspect.controller.ScanHelperController;
import com.xforceplus.ultraman.billing.client.filter.BillingFilter;
import com.xforceplus.ultraman.billing.client.impl.DefaultUsageLifecycle;
import com.xforceplus.ultraman.billing.client.remote.UsageApi;
import com.xforceplus.ultraman.billing.client.service.EntitlementService;
import com.xforceplus.ultraman.billing.client.service.impl.EntitlementServiceImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BillingClientAutoConfiguration {
    @ConditionalOnProperty(value={"ultraman.billing.filter.enabled"})
    @Bean
    public BillingFilter billingFilter(UsageApi usageApi) {
        return new BillingFilter(usageApi);
    }

    @ConditionalOnProperty(value={"ultraman.billing.filter.enabled"})
    @Bean
    public ScanHelperController scanHelperController() {
        return new ScanHelperController();
    }

    @ConditionalOnBean(value={TeamCodeSupplier.class, AppCodeSupplier.class})
    @Bean
    public BillingAspect billingAspect(TeamCodeSupplier teamCodeSupplier, AppCodeSupplier appCodeSupplier, UsageApi usageApi, @Value(value="${ultraman.billing.service}") String serviceList) {
        return new BillingAspect(teamCodeSupplier, appCodeSupplier, usageApi, serviceList);
    }

    @ConditionalOnProperty(value={"ultraman.billing.filter.enabled"})
    @Bean
    UsageLifecycle usageLifecycle() {
        return new DefaultUsageLifecycle();
    }

    @ConditionalOnBean(value={TeamCodeSupplier.class})
    @Bean
    UsageLifecycle usageLifecycle2() {
        return new DefaultUsageLifecycle();
    }

    @Bean
    public EntitlementService entitlementService() {
        return new EntitlementServiceImpl();
    }
}

