/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.billing.client.filter;

import com.fasterxml.jackson.databind.JsonNode;
import com.usthe.sureness.matcher.util.TirePathTree;
import com.usthe.sureness.mgt.SurenessSecurityManager;
import com.usthe.sureness.subject.Subject;
import com.xforceplus.ultraman.billing.client.UsageLifecycle;
import com.xforceplus.ultraman.billing.client.impl.UsageMatchedContext;
import com.xforceplus.ultraman.billing.client.remote.UsageApi;
import com.xforceplus.ultraman.billing.client.utils.CachedBodyHttpServletRequest;
import com.xforceplus.ultraman.billing.client.utils.CachedBodyHttpServletResponse;
import com.xforceplus.ultraman.billing.client.utils.ExtractUtils;
import com.xforceplus.ultraman.billing.client.utils.HttpPayloadExtractor;
import com.xforceplus.ultraman.billing.domain.CheckUsageRequest;
import com.xforceplus.ultraman.billing.domain.ResourceCreateRequest;
import com.xforceplus.ultraman.billing.domain.Response;
import com.xforceplus.ultraman.billing.domain.Usage;
import com.xforceplus.ultraman.billing.domain.UsageRequest;
import com.xforceplus.ultraman.billing.domain.UsageRule;
import com.xforceplus.ultraman.bocp.metadata.util.JsonUtils;
import com.xforceplus.ultraman.bocp.uc.context.UcUserInfoHolder;
import com.xforceplus.ultraman.bocp.uc.pojo.auth.UcAuthUser;
import io.vavr.Tuple;
import io.vavr.Tuple5;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.web.filter.OncePerRequestFilter;

public class BillingFilter
extends OncePerRequestFilter {
    private UsageApi usageApi;
    @Value(value="${ultraman.billing.service}")
    private List<String> serviceList;
    @Autowired
    private UsageLifecycle usageLifecycle;

    public BillingFilter(UsageApi usageApi) {
        this.usageApi = usageApi;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        UsageMatchedContext usageMatchedContext = null;
        String targetResource = null;
        String teamCode = null;
        ArrayList<String> matchedIds = new ArrayList<String>();
        try {
            UcAuthUser ucAuthUser = UcUserInfoHolder.get();
            if (ucAuthUser != null && !StringUtils.isEmpty((CharSequence)(teamCode = ucAuthUser.getTeamCode()))) {
                String finalTeamCode = teamCode;
                usageMatchedContext = this.usageLifecycle.matchedUsage(() -> finalTeamCode, source -> source.getExternalType().equalsIgnoreCase("HTTP"));
            }
            if (usageMatchedContext != null) {
                TirePathTree tirePathTree = new TirePathTree();
                Set resources = usageMatchedContext.getSourceIdMapping().entrySet().stream().map(e -> this.transformResource((String)e.getKey(), (List)e.getValue())).collect(Collectors.toSet());
                tirePathTree.buildTree(resources);
                List subject = SurenessSecurityManager.getInstance().createSubject(request);
                if (!subject.isEmpty()) {
                    Subject firstSubject = (Subject)subject.get(0);
                    targetResource = (String)firstSubject.getTargetResource();
                    tirePathTree.searchPathFilterRoles(request.getMethod());
                    String string = tirePathTree.searchPathFilterRoles(targetResource);
                    if (string != null) {
                        String[] ids = string.split(",");
                        matchedIds.addAll(Arrays.asList(ids));
                    }
                }
            }
        }
        catch (Throwable throwable) {
            this.logger.error((Object)throwable);
        }
        request = new CachedBodyHttpServletRequest((HttpServletRequest)request);
        ArrayList<Tuple5<Usage, String, String, Response, Integer>> passedUsageList = new ArrayList<Tuple5<Usage, String, String, Response, Integer>>();
        for (String idToken : matchedIds) {
            Tuple5<Usage, String, String, Response, Integer> tupleResponse = this.usageProcess((HttpServletRequest)request, usageMatchedContext, idToken, targetResource, teamCode);
            if ((Integer)tupleResponse._5 < 0) {
                Response failedResponse = (Response)tupleResponse._4;
                response.setContentType("application/json");
                response.setStatus(403);
                response.setCharacterEncoding("UTF8");
                if (failedResponse != null) {
                    response.getWriter().write(JsonUtils.object2Json((Object)failedResponse));
                    response.flushBuffer();
                }
                return;
            }
            passedUsageList.add(tupleResponse);
        }
        response = new CachedBodyHttpServletResponse((HttpServletResponse)response);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        if (response.getStatus() == 200) {
            HttpPayloadExtractor httpPayloadExtractor = new HttpPayloadExtractor();
            String responseBody = httpPayloadExtractor.extract((HttpServletResponse)response);
            try {
                JsonNode jsonNode = JsonUtils.readTree((String)responseBody);
                JsonNode codeNode = jsonNode.get("code");
                if (codeNode != null && !codeNode.asText().equals("0")) {
                    return;
                }
            }
            catch (Throwable throwable) {
                this.logger.warn((Object)throwable);
            }
            Map map = (Map)JsonUtils.json2Object((String)responseBody, Map.class);
            for (Tuple5 tuple5 : passedUsageList) {
                try {
                    String sizeExpr;
                    String keyExpr;
                    String targetKey = (String)tuple5._2;
                    String targetSize = (String)tuple5._3;
                    UsageRequest usageRequest = new UsageRequest();
                    usageRequest.setUsage(((Usage)tuple5._1).getName());
                    if (targetKey == null && (keyExpr = ((Usage)tuple5._1).getKeyExpr()).startsWith("RES_BODY:")) {
                        keyExpr = keyExpr.substring(9);
                        targetKey = this.evaluate(keyExpr, String.class, map);
                    }
                    if (targetSize == null && (sizeExpr = ((Usage)tuple5._1).getSizeExpr()).startsWith("RES_BODY:")) {
                        sizeExpr = sizeExpr.substring(9);
                        targetSize = this.evaluate(sizeExpr, String.class, map);
                    }
                    usageRequest.setKey(targetKey);
                    usageRequest.setSize(targetSize);
                    usageRequest.setTenant(teamCode);
                    Response response2 = this.usageApi.record(usageRequest);
                }
                catch (Throwable throwable) {
                    this.logger.error((Object)throwable);
                }
            }
        }
    }

    private String renderExpr(String expression, Map<String, Object> templateBinding) {
        for (Map.Entry<String, Object> entry : templateBinding.entrySet()) {
            String k = entry.getKey();
            Object v = entry.getValue();
            if (!expression.contains("{{".concat(k).concat("}}"))) continue;
            expression = expression.replaceAll("\\{\\{".concat(k).concat("\\}\\}"), v.toString());
        }
        return expression;
    }

    private Tuple5<Usage, String, String, Response, Integer> usageProcess(HttpServletRequest request, UsageMatchedContext context, String idToken, String targetResource, String teamCode) {
        Object maps;
        HashMap<String, Object> varMapping;
        String targetKey = null;
        String targetSize = null;
        String limitationExpr = null;
        String validationExpr = null;
        String dryRunSizeExpr = null;
        String keyExpr = null;
        String sizeExpr = null;
        ResourceCreateRequest relatedResource = null;
        Usage targetUsage = null;
        if (idToken.startsWith("rule")) {
            UsageRule usageRule = context.getUsageRuleById(idToken = idToken.substring(5));
            if (usageRule != null) {
                targetUsage = context.getUsageByRuleId(idToken);
                Map templateBinding = targetUsage.getTemplateBinding();
                limitationExpr = targetUsage.getLimitation();
                validationExpr = usageRule.getValidateExpr() == null ? null : this.renderExpr(usageRule.getValidateExpr(), templateBinding);
                dryRunSizeExpr = usageRule.getDryRunSizeExpr() == null ? null : this.renderExpr(usageRule.getDryRunSizeExpr(), templateBinding);
                keyExpr = usageRule.getKeyExpr() == null ? null : this.renderExpr(usageRule.getKeyExpr(), templateBinding);
                sizeExpr = usageRule.getSizeExpr() == null ? null : this.renderExpr(usageRule.getSizeExpr(), templateBinding);
                relatedResource = usageRule.getResourceRef();
            }
        } else {
            Usage usage = context.getUsageById(idToken);
            limitationExpr = usage.getLimitation();
            validationExpr = usage.getLimitationExpr();
            dryRunSizeExpr = usage.getDryRunSizeExpr();
            keyExpr = usage.getKeyExpr();
            sizeExpr = usage.getSizeExpr();
            relatedResource = usage.getResourceRef();
            targetUsage = usage;
        }
        HttpPayloadExtractor httpPayloadExtractor = new HttpPayloadExtractor();
        if (StringUtils.isEmpty(sizeExpr)) {
            targetSize = "1";
        } else {
            boolean skipEvaluation = false;
            varMapping = new HashMap<String, Object>();
            if (sizeExpr.startsWith("BODY:")) {
                sizeExpr = sizeExpr.substring(5);
                String extractRequest = httpPayloadExtractor.extract(request);
                if (extractRequest.startsWith("{")) {
                    Map map = (Map)JsonUtils.json2Object((String)extractRequest, Map.class);
                    varMapping.putAll(map);
                } else if (extractRequest.startsWith("[")) {
                    maps = JsonUtils.json2ObjectList((String)extractRequest, Map.class);
                    varMapping.put("root", maps);
                }
            } else if (sizeExpr.startsWith("PATH:")) {
                sizeExpr = sizeExpr.substring(5);
                if (relatedResource != null) {
                    this.preparePathEnv(relatedResource.getExternalResource(), targetResource, varMapping);
                }
            } else if (sizeExpr.startsWith("QUERY:")) {
                sizeExpr = sizeExpr.substring(6);
            } else {
                skipEvaluation = true;
            }
            targetSize = !skipEvaluation ? this.evaluate(sizeExpr, String.class, varMapping) : sizeExpr;
        }
        if (StringUtils.isEmpty((CharSequence)keyExpr)) {
            targetKey = "default";
        } else {
            boolean skipEvaluation = false;
            varMapping = new HashMap();
            if (keyExpr.startsWith("BODY:")) {
                keyExpr = keyExpr.substring(5);
            } else if (keyExpr.startsWith("PATH:")) {
                keyExpr = keyExpr.substring(5);
                if (relatedResource != null) {
                    this.preparePathEnv(relatedResource.getExternalResource(), targetResource, varMapping);
                }
            } else if (keyExpr.startsWith("QUERY:")) {
                String queryString = request.getQueryString();
                Map<String, Object> mapping = BillingFilter.parseQueryString(queryString);
                varMapping.putAll(mapping);
                keyExpr = keyExpr.substring(6);
            } else if (keyExpr.startsWith("HEADER:")) {
                Enumeration headerNames = request.getHeaderNames();
                while (headerNames.hasMoreElements()) {
                    String next = (String)headerNames.nextElement();
                    varMapping.put(next, request.getHeader(next));
                }
                keyExpr = keyExpr.substring(7);
            } else {
                skipEvaluation = true;
            }
            if (!skipEvaluation) {
                targetKey = this.evaluate(keyExpr, String.class, varMapping);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)validationExpr) && validationExpr.startsWith("BODY:")) {
            validationExpr = validationExpr.substring(5);
            String extract = httpPayloadExtractor.extract(request);
            if (!StringUtils.isEmpty((CharSequence)extract)) {
                Boolean isPassed = true;
                if (extract.startsWith("{")) {
                    Map maps2 = (Map)JsonUtils.json2Object((String)extract, Map.class);
                    isPassed = this.evaluate(validationExpr, Boolean.class, maps2);
                } else if (extract.startsWith("[")) {
                    List mapList = JsonUtils.json2ObjectList((String)extract, Map.class);
                    maps = new HashMap();
                    maps.put("root", mapList);
                    isPassed = this.evaluate(validationExpr, Boolean.class, (Map<String, Object>)maps);
                }
                if (!isPassed.booleanValue()) {
                    Response overResp = new Response();
                    overResp.setCode("-1");
                    overResp.setMessage(targetUsage.getErrorMsg());
                    return Tuple.of((Object)targetUsage, null, null, (Object)overResp, (Object)-1);
                }
            }
        }
        if (!StringUtils.isEmpty((CharSequence)limitationExpr)) {
            CheckUsageRequest checkUsageRequest = new CheckUsageRequest();
            if (!StringUtils.isEmpty((CharSequence)dryRunSizeExpr)) {
                if (dryRunSizeExpr.startsWith("BODY:")) {
                    dryRunSizeExpr = dryRunSizeExpr.substring(5);
                    String extract = httpPayloadExtractor.extract(request);
                    if (!StringUtils.isEmpty((CharSequence)extract)) {
                        String dryRunSize = "1";
                        if (extract.startsWith("{")) {
                            maps = (Map)JsonUtils.json2Object((String)extract, Map.class);
                            dryRunSize = this.evaluate(dryRunSizeExpr, String.class, (Map<String, Object>)maps);
                        } else if (extract.startsWith("[")) {
                            List mapList = JsonUtils.json2ObjectList((String)extract, Map.class);
                            HashMap<String, Object> maps3 = new HashMap<String, Object>();
                            maps3.put("root", mapList);
                            dryRunSize = this.evaluate(dryRunSizeExpr, String.class, maps3);
                        }
                        checkUsageRequest.setDryRunValue(dryRunSize);
                    }
                } else {
                    checkUsageRequest.setDryRunValue(dryRunSizeExpr);
                }
            }
            if (checkUsageRequest.getDryRunValue() == null) {
                checkUsageRequest.setDryRunValue("1");
            }
            checkUsageRequest.setUsage(targetUsage);
            checkUsageRequest.setTenant(teamCode);
            checkUsageRequest.setRecordKey(targetKey);
            Response checkUsage = this.usageApi.checkUsage(checkUsageRequest);
            if (!"1".equalsIgnoreCase(checkUsage.getCode())) {
                return Tuple.of((Object)targetUsage, null, null, (Object)checkUsage, (Object)-1);
            }
        }
        return Tuple.of((Object)targetUsage, (Object)targetKey, (Object)targetSize, null, (Object)1);
    }

    private void preparePathEnv(String rawResource, String targetResource, Map<String, Object> varMapping) {
        String[] split = rawResource.split(" ");
        if (split.length == 2) {
            String url = split[1];
            ExtractUtils.extractKeyValueMapping(url, targetResource).forEach((k, v) -> varMapping.put("path.".concat((String)k), v));
        }
    }

    private String getValue(String expression, HttpServletRequest request) {
        HttpPayloadExtractor httpPayloadExtractor = new HttpPayloadExtractor();
        return httpPayloadExtractor.extract(request);
    }

    private String transformResource(String rawResource, List<String> usageIds) {
        String[] split = rawResource.split(" ");
        if (split.length == 2) {
            String method = split[0];
            String url = split[1];
            if (url.contains("{") && url.contains("}")) {
                url = url.replaceAll("\\{[^/]+\\}", "*");
            }
            return url.concat("===").concat(method.toLowerCase()).concat("===").concat(Strings.join(usageIds, (char)','));
        }
        return null;
    }

    private <T> T evaluate(String keyExpr, Class<T> clz, Map<String, Object> varMapping) {
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext ec = new StandardEvaluationContext(varMapping);
        Expression expression = parser.parseExpression(keyExpr);
        Object result = expression.getValue((EvaluationContext)ec, clz);
        return (T)result;
    }

    public static Map<String, Object> parseQueryString(String queryString) {
        if (StringUtils.isEmpty((CharSequence)queryString)) {
            return null;
        }
        int index = queryString.indexOf("?");
        if (index >= 0) {
            queryString = queryString.substring(index + 1);
        }
        HashMap<String, Object> argMap = new HashMap<String, Object>();
        String[] queryArr = queryString.split("&");
        for (int i = 0; i < queryArr.length; ++i) {
            String string = queryArr[i];
            String[] keyAndValue = string.split("=", 2);
            if (keyAndValue.length != 2) {
                argMap.put(keyAndValue[0], null);
                continue;
            }
            argMap.put(keyAndValue[0], keyAndValue[1]);
        }
        return argMap;
    }
}

