/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.billing.client.impl;

import com.xforceplus.ultraman.billing.client.UsageLifecycle;
import com.xforceplus.ultraman.billing.client.dto.UsageResponse;
import com.xforceplus.ultraman.billing.client.impl.UsageMatchedContext;
import com.xforceplus.ultraman.billing.client.remote.UsageApi;
import com.xforceplus.ultraman.billing.domain.ListUsageRequest;
import com.xforceplus.ultraman.billing.domain.ResourceCreateRequest;
import com.xforceplus.ultraman.billing.domain.Usage;
import com.xforceplus.ultraman.billing.domain.UsageRule;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class DefaultUsageLifecycle
implements UsageLifecycle {
    @Value(value="${ultraman.billing.service}")
    private List<String> serviceList;
    @Autowired
    private UsageApi usageApi;

    @Override
    public UsageMatchedContext matchedUsage(Supplier<String> teamCodeSupplier, Predicate<ResourceCreateRequest> filter) {
        List<Usage> usageList;
        String teamCode = teamCodeSupplier.get();
        ListUsageRequest listUsageRequest = new ListUsageRequest();
        listUsageRequest.setService(this.serviceList);
        listUsageRequest.setTenant(teamCode);
        UsageResponse allUsages = this.usageApi.getAllUsages(listUsageRequest);
        UsageMatchedContext usageMatchedContext = new UsageMatchedContext();
        if (allUsages.getCode().equalsIgnoreCase("1") && (usageList = allUsages.getResult()) != null) {
            usageList.forEach(usage -> {
                ResourceCreateRequest resourceRef = usage.getResourceRef();
                if (resourceRef != null) {
                    if (filter.test(resourceRef)) {
                        usageMatchedContext.accept((Usage)usage, resourceRef);
                    }
                } else if (usage.getRules() != null && !usage.getRules().isEmpty()) {
                    List rules = usage.getRules();
                    rules.stream().filter(x -> x.getResourceRef() != null).forEach(x -> {
                        ResourceCreateRequest relatedResource = x.getResourceRef();
                        if (filter.test(relatedResource)) {
                            usageMatchedContext.accept((Usage)usage, (UsageRule)x);
                        }
                    });
                }
            });
        }
        return usageMatchedContext;
    }
}

