/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.billing.client.impl;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.xforceplus.ultraman.billing.client.LicenceService;
import com.xforceplus.ultraman.billing.client.remote.BillingApi;
import com.xforceplus.ultraman.billing.domain.CheckResponse;
import com.xforceplus.ultraman.billing.domain.LicenceRequest;
import com.xforceplus.ultraman.billing.domain.LicenceResource;
import com.xforceplus.ultraman.billing.domain.LicenceResponse;
import com.xforceplus.ultraman.bocp.uc.context.UcUserInfoHolder;
import com.xforceplus.ultraman.bocp.uc.pojo.auth.UcAuthUser;
import io.github.jamsesso.jsonlogic.JsonLogic;
import io.github.jamsesso.jsonlogic.JsonLogicException;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

public class LicenceServiceImpl
implements LicenceService {
    @Autowired
    private BillingApi billingApi;
    private LoadingCache<LicenceRequest, LicenceResponse> licenceCaches = Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(Duration.ofMinutes(10L)).build(x -> {
        LicenceResponse licenceResponse = this.billingApi.fetchLicence((LicenceRequest)x);
        if (licenceResponse.getCode() == 1) {
            return licenceResponse;
        }
        return null;
    });

    @Override
    public CheckResponse checkResource(String identity, List<Object> inputParams) {
        LicenceRequest licenceRequest = new LicenceRequest();
        UcAuthUser ucAuthUser = UcUserInfoHolder.get();
        CheckResponse checkResponse = new CheckResponse();
        if (ucAuthUser != null) {
            List resources;
            Optional<LicenceResource> targetResourceRule;
            licenceRequest.setUser(ucAuthUser.getAccountId().toString());
            LicenceResponse licenceResponse = (LicenceResponse)this.licenceCaches.get((Object)licenceRequest);
            if (licenceResponse != null && licenceResponse.getCode() == 1 && (targetResourceRule = (resources = licenceResponse.getResources()).stream().filter(x -> this.isIdentity((LicenceResource)x, identity)).findAny()).isPresent()) {
                LicenceResource licenceResource = targetResourceRule.get();
                List params = licenceResource.getParams();
                boolean isPassed = this.checkParams(licenceResource, inputParams);
                if (isPassed) {
                    checkResponse.setCode(1);
                } else {
                    checkResponse.setCode(-1);
                    checkResponse.setMessageCode(licenceResource.getMessageCode());
                    checkResponse.setDefaultMessage(licenceResource.getDefaultMessage());
                }
            }
            return checkResponse;
        }
        return null;
    }

    private boolean isIdentity(LicenceResource src, String target) {
        return src.getResourceId().equalsIgnoreCase(target);
    }

    private boolean checkParams(LicenceResource src, List<Object> inputParams) {
        HashMap variable = new HashMap();
        String expression = src.getExpression();
        JsonLogic jsonLogic = new JsonLogic();
        boolean result = false;
        try {
            result = (Boolean)jsonLogic.apply(expression, variable);
            return result;
        }
        catch (JsonLogicException e) {
            return false;
        }
    }
}

