/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.billing.client.impl;

import com.xforceplus.ultraman.billing.domain.ResourceCreateRequest;
import com.xforceplus.ultraman.billing.domain.Usage;
import com.xforceplus.ultraman.billing.domain.UsageRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class UsageMatchedContext {
    private Map<String, List<String>> sourceIdMapping = new HashMap<String, List<String>>();
    private Map<String, Usage> usageIdMapping = new HashMap<String, Usage>();
    private Map<String, UsageRule> usageRuleIdMapping = new HashMap<String, UsageRule>();
    private Map<String, Usage> ruleIdUsageMapping = new HashMap<String, Usage>();

    public Map<String, List<String>> getSourceIdMapping() {
        return this.sourceIdMapping;
    }

    public Map<String, Usage> getUsageIdMapping() {
        return this.usageIdMapping;
    }

    public void accept(Usage usage, ResourceCreateRequest resource) {
        this.usageIdMapping.put(usage.getId(), usage);
        String externalResource = resource.getExternalResource();
        this.sourceIdMapping.compute(externalResource, (k, v) -> {
            if (v == null) {
                v = new ArrayList<String>();
            }
            v.add(usage.getId());
            return v;
        });
    }

    public void accept(Usage usage, UsageRule rule) {
        this.usageIdMapping.put(usage.getId(), usage);
        this.usageRuleIdMapping.put(rule.getId().toString(), rule);
        this.ruleIdUsageMapping.put(rule.getId().toString(), usage);
        ResourceCreateRequest resourceRef = rule.getResourceRef();
        if (resourceRef != null) {
            String externalResource = resourceRef.getExternalResource();
            this.sourceIdMapping.compute(externalResource, (k, v) -> {
                if (v == null) {
                    v = new ArrayList<String>();
                }
                v.add("rule-".concat(rule.getId().toString()));
                return v;
            });
        }
    }

    public Collection<? extends Usage> findUsagesByIds(String[] ids) {
        return Arrays.stream(ids).map(id -> this.usageIdMapping.get(id)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public UsageRule getUsageRuleById(String idToken) {
        return this.usageRuleIdMapping.get(idToken);
    }

    public Usage getUsageById(String idToken) {
        return this.usageIdMapping.get(idToken);
    }

    public Usage getUsageByRuleId(String idToken) {
        return this.ruleIdUsageMapping.get(idToken);
    }
}

