package com.xforceplus.ultraman.transfer.client.config;

import com.xforceplus.ultraman.transfer.client.BocpHttpClient;
import com.xforceplus.ultraman.transfer.client.IBocpClient;
import com.xforceplus.ultraman.transfer.client.listener.IBocpServerMessageListener;
import com.xforceplus.ultraman.transfer.storage.http.interceptor.MetadataHeadInterceptor;
import com.xforceplus.ultraman.transfer.storage.http.token.BocpGatewayTokenClient;
import com.xforceplus.ultraman.transfer.storage.http.token.TokenManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;

@Configuration
@ConditionalOnProperty(prefix = "ultraman.transfer", name = "enabled", matchIfMissing = false)
public class BocpHttpClientConfiguration {

    /**
     *     @Value("${ultraman.transfer.bocp.authUrl:https://paas-s.xforceplus.com}")
     *     String authUrl;
     *     @Value("${ultraman.transfer.bocp.clientId:tg_ultraman_auth}")
     *     String clientId;
     *     @Value("${ultraman.transfer.bocp.secret:YVFY1q123Blp9c}")
     *     String secret;
     * @param bocpClientSetting
     * @param oqsSdkProperties
     * @param listeners
     * @return
     */
    @ConditionalOnMissingBean(IBocpClient.class)
    @Bean
    public IBocpClient bocpClient(BocpClientSetting bocpClientSetting, OqsSdkProperties oqsSdkProperties
            , @Autowired(required = false) List<IBocpServerMessageListener> listeners
            , @Value("${ultraman.transfer.bocp.authUrl:https://paas-s.xforceplus.com}") String authUrl
            , @Value("${ultraman.transfer.bocp.clientId:tg_ultraman_auth}") String clientId
            , @Value("${ultraman.transfer.bocp.secret:YVFY1q123Blp9c}") String secret
            , @Value("${ultraman.transfer.bocp.useSsl:true}") Boolean useSsl
            , @Value("${ultraman.transfer.bocp.host:ultraman.xforcecloud.com/bocp}") String bocpHost
            , @Value("${ultraman.transfer.bocp.apiPrefix:api/global/bocp}") String apiPrefix
    ) {
        /**
         * String bocpHost,
         *                            Boolean useSsl,
         *                            String apiPrefix,
         *                            OqsSdkProperties oqsSdkProperties,
         *                            MetadataHeadInterceptor metadataHeadInterceptor, List<IBocpServerMessageListener> listeners
         */
        BocpGatewayTokenClient bocpGatewayTokenClient = new BocpGatewayTokenClient(authUrl, clientId, secret);
        TokenManager tokenManager = new TokenManager(bocpGatewayTokenClient);
        MetadataHeadInterceptor metadataHeadInterceptor = new MetadataHeadInterceptor(tokenManager);
        return new BocpHttpClient(bocpHost, useSsl, apiPrefix, oqsSdkProperties, bocpClientSetting
                , metadataHeadInterceptor, listeners);
    }
    
}
