package com.xforceplus.ultraman.transfer.client.ddl;

import com.xforceplus.ultraman.transfer.client.IBocpClient;
import com.xforceplus.ultraman.transfer.client.config.OqsSdkProperties;
import com.xforceplus.ultraman.transfer.common.util.JsonUtils;
import com.xforceplus.ultraman.transfer.common.util.MessageUtils;
import com.xforceplus.ultraman.transfer.domain.entity.TransferMessage;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.context.event.EventListener;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2024/1/17 18:43
 * Description:
 * History:
 */
@Slf4j
public class BocpClientDdlEventListener {

    private OqsSdkProperties oqsSdkProperties;

    private IBocpClient bocpClient;

    public BocpClientDdlEventListener(OqsSdkProperties oqsSdkProperties, IBocpClient bocpClient) {
        this.oqsSdkProperties = oqsSdkProperties;
        this.bocpClient = bocpClient;
    }

    /**
     * 抛事件方式实现 备用
     * @param event
     */
    @EventListener({DdlDemoEvent.class})
    public void onApplicationEvent(DdlDemoEvent event) {
        TransferMessage message = new TransferMessage();
        message.setId(event.getMessageId());
        message.setHandleSuccess(event.isHandleSuccess());
        message.setHandleMessage(event.getHandleMessage());

        message.setAppId(Long.valueOf(oqsSdkProperties.getAuth().getAppId()));
        message.setEnv(oqsSdkProperties.getAuth().getEnv());

        TransferMessage replyMessage = null;
        try {
            //TODO DDL执行完回执
            Thread.sleep(1000);
            log.info("event trigger executing ddl");
        } catch (InterruptedException e) {
            log.error("dll reply failed!", e);
            replyMessage = MessageUtils.buildReplyMessage(message, false, ExceptionUtils.getStackTrace(e));
        } finally {
            bocpClient.sendMessage(JsonUtils.object2Json(replyMessage));
        }

    }
}
