package com.xforceplus.ultraman.transfer.client.front.runtime;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.utils.IOUtils;
import com.aliyun.oss.model.OSSObject;
import com.xforceplus.ultraman.metadata.jsonschema.enums.SchemaMetadataType;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.CharEncoding;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2023/4/20 17:53
 * Description:
 * History:
 */
@Slf4j
public class MetadataAliyunOSSClient {

    private final OSS oss;

    public MetadataAliyunOSSClient(OSS oss) {
        this.oss = oss;
    }

    public String loadAppVersionStr(Long appId, String version) {
        String filePath = AliyunOSSConstant.getAppVersionFilePath(appId, version);
        return getDataStrFromOSS(filePath);
    }

    public String loadEnvAppVersion(String envCode, String appCode) {
        String filePath = AliyunOSSConstant.getEnvAppVersionFilePath(envCode, appCode);
        return getDataStrFromOSS(filePath);
    }

    public String loadMetadataStr(Long appId, SchemaMetadataType metadataType, String version) {
        String filePath = AliyunOSSConstant.getMetadataFilePath(metadataType, appId, version);
        return getDataStrFromOSS(filePath);
    }

    public String loadMetadataSStr(Long appId, SchemaMetadataType metadataType, Long metadataId, String version, String fileName) {
        String filePath = AliyunOSSConstant.getMetadataSFilePath(metadataType, appId, metadataId, version, fileName);
        return getDataStrFromOSS(filePath);
    }

    public String loadMetadataSItemStr(Long appId, SchemaMetadataType metadataType, Long metadataId, String version, String dirName, Long metadataItemId) {
        String filePath = AliyunOSSConstant.getMetadataSItemFilePath(metadataType, appId, metadataId, version, dirName, metadataItemId);
        return getDataStrFromOSS(filePath);
    }

    public String loadTenantMetadataSStr(Long appId, SchemaMetadataType metadataType, Long metadataId, String version, String tenantCode, String fileName) {
        String filePath = AliyunOSSConstant.getTenantMetadataSFilePath(metadataType, appId, metadataId, version, tenantCode, fileName);
        return getDataStrFromOSS(filePath);
    }

    public String loadTenantMetadataSItemStr(Long appId, SchemaMetadataType metadataType, Long metadataId, String version, String tenantCode, String dirName, Long metadataItemId) {
        String filePath = AliyunOSSConstant.getTenantMetadataSItemFilePath(metadataType, appId, metadataId, version, tenantCode, dirName, metadataItemId);
        return getDataStrFromOSS(filePath);
    }

    private String getDataStrFromOSS(String filePath) {
        try {
            if(!oss.doesObjectExist(AliyunOSSConstant.BUCKET_NAME, filePath)) {
                log.debug("filePath {} not found in oss", filePath);
                return null;
            }
            OSSObject ossObject = oss.getObject(AliyunOSSConstant.BUCKET_NAME, filePath);
            return IOUtils.readStreamAsString(ossObject.getObjectContent(), CharEncoding.UTF_8);
        } catch (OSSException oe) {
            log.error("Caught an OSSException, which means your request made it to OSS, "
                    + "but was rejected with an error response for some reason.");
            log.error("Error Message:" + oe.getErrorMessage());
            log.error("Error Code:" + oe.getErrorCode());
            log.error("Request ID:" + oe.getRequestId());
            log.error("Host ID:" + oe.getHostId());
        } catch (ClientException ce) {
            log.error("Caught an ClientException, which means the client encountered "
                    + "a serious internal problem while trying to communicate with OSS, "
                    + "such as not being able to access the network.");
            log.error("Error Message:" + ce.getMessage());
        } catch (Exception e) {
            log.error("could not load tenant metadata", e);
        }
        return null;
    }

}
