/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.transfer.client;

import com.xforceplus.ultraman.transfer.client.BocpHttpClient;
import com.xforceplus.ultraman.transfer.client.config.BocpClientSetting;
import com.xforceplus.ultraman.transfer.client.config.OqsSdkProperties;
import com.xforceplus.ultraman.transfer.client.listener.IBocpServerMessageListener;
import com.xforceplus.ultraman.transfer.common.util.MessageUtils;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.Request;

public class JanusBocpHttpClient
extends BocpHttpClient {
    private String janusBase;
    private String authentication;
    private String action;
    private boolean useSSL;

    public JanusBocpHttpClient(String janusBase, String authentication, String action, boolean useSSL, OqsSdkProperties oqsSdkProperties, BocpClientSetting bocpClientSetting, List<IBocpServerMessageListener> listeners) {
        super(useSSL, bocpClientSetting, oqsSdkProperties, listeners);
        this.janusBase = janusBase;
        this.authentication = authentication;
        this.action = action;
        this.useSSL = useSSL;
        this.init();
    }

    @Override
    protected Request buildRequest(Long appId, Long envId) {
        String url = this.janusBase;
        HttpUrl hostUrl = HttpUrl.get((String)url);
        HttpUrl httpUrl = new HttpUrl.Builder().scheme(MessageUtils.getSchema((boolean)this.useSSL)).host(hostUrl.host()).port(hostUrl.port()).addQueryParameter("appId", appId.toString()).addQueryParameter("envId", envId.toString()).build();
        return new Request.Builder().addHeader("Authentication", this.authentication).addHeader("serialNo", appId.toString()).addHeader("action", this.action).url(httpUrl).build();
    }
}

