/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.transfer.client.config;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSClientBuilder;
import com.xforceplus.ultraman.transfer.client.config.BocpClientSetting;
import com.xforceplus.ultraman.transfer.client.config.OqsSdkProperties;
import com.xforceplus.ultraman.transfer.client.controller.BocpClientOSSMetadataController;
import com.xforceplus.ultraman.transfer.client.front.runtime.MetadataAliyunOSSClient;
import com.xforceplus.ultraman.transfer.storage.aggregator.properties.BocpTransferStorageProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="ultraman.transfer", name={"enabled"}, matchIfMissing=false)
@EnableConfigurationProperties(value={BocpClientSetting.class, BocpTransferStorageProperties.class})
public class BocpFrontMetadataConfiguration {
    @Bean(value={"pfcpOSSClient"})
    public OSS pfcpOSSClient(BocpTransferStorageProperties config) {
        return new OSSClientBuilder().build(config.getAliyunossEndpoint(), config.getAliyunossAccessKey(), config.getAliyunossSecretKey());
    }

    @ConditionalOnBean(name={"pfcpOSSClient"})
    @Bean
    public MetadataAliyunOSSClient metadataAliyunOSSClient(OSSClient pfcpOSSClient) {
        return new MetadataAliyunOSSClient((OSS)pfcpOSSClient);
    }

    @ConditionalOnBean(value={MetadataAliyunOSSClient.class})
    @Bean
    public BocpClientOSSMetadataController bocpClientOSSMetadataController(OqsSdkProperties oqsSdkProperties, MetadataAliyunOSSClient metadataAliyunOSSClient) {
        return new BocpClientOSSMetadataController(oqsSdkProperties, metadataAliyunOSSClient);
    }
}

