/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.transfer.client.config;

import com.xforceplus.ultraman.transfer.client.BocpHttpClient;
import com.xforceplus.ultraman.transfer.client.IBocpClient;
import com.xforceplus.ultraman.transfer.client.config.BocpClientSetting;
import com.xforceplus.ultraman.transfer.client.config.OqsSdkProperties;
import com.xforceplus.ultraman.transfer.client.listener.IBocpServerMessageListener;
import com.xforceplus.ultraman.transfer.storage.http.interceptor.MetadataHeadInterceptor;
import com.xforceplus.ultraman.transfer.storage.http.token.BocpGatewayTokenClient;
import com.xforceplus.ultraman.transfer.storage.http.token.TokenManager;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="ultraman.transfer", name={"enabled"}, matchIfMissing=false)
public class BocpHttpClientConfiguration {
    @ConditionalOnMissingBean(value={IBocpClient.class})
    @Bean
    public IBocpClient bocpClient(BocpClientSetting bocpClientSetting, OqsSdkProperties oqsSdkProperties, @Autowired(required=false) List<IBocpServerMessageListener> listeners, @Value(value="${ultraman.transfer.bocp.authUrl:https://paas-s.xforceplus.com}") String authUrl, @Value(value="${ultraman.transfer.bocp.clientId:tg_ultraman_auth}") String clientId, @Value(value="${ultraman.transfer.bocp.secret:YVFY1q123Blp9c}") String secret, @Value(value="${ultraman.transfer.bocp.useSsl:true}") Boolean useSsl, @Value(value="${ultraman.transfer.bocp.host:ultraman.xforcecloud.com/bocp}") String bocpHost, @Value(value="${ultraman.transfer.bocp.apiPrefix:api/global/bocp}") String apiPrefix) {
        BocpGatewayTokenClient bocpGatewayTokenClient = new BocpGatewayTokenClient(authUrl, clientId, secret);
        TokenManager tokenManager = new TokenManager(bocpGatewayTokenClient);
        MetadataHeadInterceptor metadataHeadInterceptor = new MetadataHeadInterceptor(tokenManager);
        return new BocpHttpClient(bocpHost, useSsl, apiPrefix, oqsSdkProperties, bocpClientSetting, metadataHeadInterceptor, listeners);
    }
}

