package com.xforceplus.ultraman.transfer.client.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;
import java.util.List;

/**
 * .
 *
 * @author leo
 * @version 0.1 2022/11/7 19:18
 * @since 1.8
 */

@ConfigurationProperties(prefix = "ultraman.transfer")
@Data
public class BocpClientSetting {

    private Bocp bocp = new Bocp();

    @Data
    public static class Bocp {
        private Long connectTimeOut;
        private Integer maxFailRetryTimes;
        
        private boolean supportOffline = false;
        
        private int failureThreshold = 3;

        //bocp
        private String host = "ultraman.xforcecloud.com/bocp";
        private boolean useSsl = true;
        private String apiPrefix = "api/global/bocp";
        private String env = "prod";

        //用户中心
        private String authUrl = "https://paas-s.xforceplus.com";
        private String clientId = "tg_ultraman_auth";
        private String secret = "YVFY1q123Blp9c"; //sit
//        private String secret = "0QHOcifR1"; // fat

        //Deprecated
        private String port;

        //元数据可选项，包括page,form; 当指定这两项时，才会同步
        List<String> extraMetadataTypes = new ArrayList<>();

        /**
         * enable sdkConfig
         */
        private Boolean enableSDKConfig = true;
    }

}
