package com.xforceplus.ultraman.transfer.client;

import com.xforceplus.ultraman.transfer.client.config.BocpClientSetting;
import com.xforceplus.ultraman.transfer.client.config.OqsSdkProperties;
import com.xforceplus.ultraman.transfer.client.listener.IBocpServerMessageListener;
import com.xforceplus.ultraman.transfer.common.util.MessageUtils;
import okhttp3.HttpUrl;
import okhttp3.Request;

import java.util.List;

public class JanusBocpHttpClient extends BocpHttpClient {
    
    private String janusBase;
    
    private String authentication;
    
    private String action;
    
    private boolean useSSL;

    public JanusBocpHttpClient(String janusBase, String authentication, String action, boolean useSSL
            , OqsSdkProperties oqsSdkProperties, BocpClientSetting bocpClientSetting, List<IBocpServerMessageListener> listeners) {
        super(useSSL, bocpClientSetting, oqsSdkProperties, listeners);
        this.janusBase = janusBase;
        this.authentication = authentication;
        this.action = action;
        this.useSSL = useSSL;
        init();
    }

    @Override
    protected Request buildRequest(Long appId, Long envId) {
        String url = janusBase;
        HttpUrl hostUrl = HttpUrl.get(url);
        
        HttpUrl httpUrl = new HttpUrl.Builder()
                .scheme(MessageUtils.getSchema(useSSL))
                .host(hostUrl.host())
                .port(hostUrl.port())// 添加路径段，如果有多个路径段，可以多次调用这个方法
                .addQueryParameter("appId", appId.toString())  // 添加查询参数// 添加查询参数
                .addQueryParameter("envId", envId.toString())  // 添加查询参数// 添加查询参数
                .build();
        return new Request.Builder()
                .addHeader("Authentication", authentication)
                .addHeader("serialNo", appId.toString())
                .addHeader("action", action)
                .url(httpUrl)
                .build();
    }
}
