package com.xforceplus.ultraman.transfer.client.config;

import com.xforceplus.ultraman.transfer.client.BocpClient;
import com.xforceplus.ultraman.transfer.client.IBocpClient;
import com.xforceplus.ultraman.transfer.client.controller.BocpClientController;
import com.xforceplus.ultraman.transfer.client.listener.IBocpServerMessageListener;
import com.xforceplus.ultraman.transfer.client.listener.impl.BocpServerMessageListenerImpl;
import com.xforceplus.ultraman.transfer.client.thread.MessageWorkerManager;
import com.xforceplus.ultraman.transfer.common.event.SDKMetadataEvent;
import com.xforceplus.ultraman.transfer.common.event.publisher.EventStream;
import com.xforceplus.ultraman.transfer.common.event.publisher.RxEventStream;
import com.xforceplus.ultraman.transfer.domain.entity.Response;
import com.xforceplus.ultraman.transfer.domain.entity.TransferMessage;
import com.xforceplus.ultraman.transfer.storage.aggregator.strategy.MetadataStorageRepository;
import io.vavr.Tuple2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

import java.util.List;
import java.util.concurrent.Future;

/**
 * .
 *
 * @author leo
 * @version 0.1 2022/11/7 19:28
 * @since 1.8
 */
@Configuration
@ConditionalOnProperty(prefix = "ultraman.transfer", name = "enabled", matchIfMissing = false)
@EnableConfigurationProperties(value = {BocpClientSetting.class})
public class BocpClientConfiguration {

    @Bean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }


    @ConditionalOnExpression("${ultraman.transfer.websocket.enabled:true} == true")
    @Bean
    public IBocpClient bocpClient(BocpClientSetting bocpClientSetting, OqsSdkProperties oqsSdkProperties, @Autowired(required = false) List<IBocpServerMessageListener> listeners) {
        return new BocpClient(bocpClientSetting, oqsSdkProperties, listeners);
    }

    @Bean
    public MessageWorkerManager messageWorkerManager() {
        return new MessageWorkerManager();
    }

    @Bean
    public EventStream<SDKMetadataEvent> eventEventStream() {
        return new RxEventStream<>();
    }

    @Bean
    public EventStream<Tuple2<TransferMessage, Future<Response>>> ddlDetailEventStream() {
        return new RxEventStream<>();
    }

    @Bean
    public IBocpServerMessageListener serverMessageListener(
            BocpClientSetting bocpClientSetting,
            OqsSdkProperties oqsSdkProperties,
            MetadataStorageRepository metadataStorageRepository,
            MessageWorkerManager messageWorkerManager,
            EventStream<SDKMetadataEvent> eventStream,
            EventStream<Tuple2<TransferMessage, Future<Response>>> ddlDetailEventStream
    ) {
        return new BocpServerMessageListenerImpl(bocpClientSetting, oqsSdkProperties, metadataStorageRepository
                , messageWorkerManager, eventStream, ddlDetailEventStream);
    }

    @ConditionalOnBean(IBocpClient.class)
    @Bean
    public BocpClientController bocpClientController(OqsSdkProperties oqsSdkProperties, BocpClient bocpClient) {
        return new BocpClientController(oqsSdkProperties, bocpClient);
    }
}
