package com.xforceplus.ultraman.transfer.client.config;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSClientBuilder;
import com.xforceplus.ultraman.transfer.client.controller.BocpClientOSSMetadataController;
import com.xforceplus.ultraman.transfer.client.front.runtime.MetadataAliyunOSSClient;
import com.xforceplus.ultraman.transfer.storage.aggregator.properties.BocpTransferStorageProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * .
 *
 * @author youyifan
 * @version 0.1 2024/04/26 19:28
 * @since 1.8
 */
@Configuration
@ConditionalOnProperty(prefix = "ultraman.transfer", name = "enabled", matchIfMissing = false)
@EnableConfigurationProperties(value = { BocpClientSetting.class, BocpTransferStorageProperties.class })
public class BocpFrontMetadataConfiguration {

    @Bean("pfcpOSSClient")
    public OSS pfcpOSSClient(BocpTransferStorageProperties config) {
        return new OSSClientBuilder().build(
                config.getAliyunossEndpoint(),
                config.getAliyunossAccessKey(),
                config.getAliyunossSecretKey());
    }

    @ConditionalOnBean(name = "pfcpOSSClient")
    @Bean
    public MetadataAliyunOSSClient metadataAliyunOSSClient(OSSClient pfcpOSSClient) {
        return new MetadataAliyunOSSClient(pfcpOSSClient);
    }

    @ConditionalOnBean(MetadataAliyunOSSClient.class)
    @Bean
    public BocpClientOSSMetadataController bocpClientOSSMetadataController(OqsSdkProperties oqsSdkProperties, MetadataAliyunOSSClient metadataAliyunOSSClient) {
        return new BocpClientOSSMetadataController(oqsSdkProperties, metadataAliyunOSSClient);
    }

}
