/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.transfer.client.controller;

import com.google.common.collect.Lists;
import com.xforceplus.ultraman.metadata.global.common.enums.AppI18nResourceType;
import com.xforceplus.ultraman.metadata.jsonschema.enums.SchemaMetadataType;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.version.SchemaAppVersion;
import com.xforceplus.ultraman.transfer.client.config.OqsSdkProperties;
import com.xforceplus.ultraman.transfer.client.front.runtime.MetadataAliyunOSSClient;
import com.xforceplus.ultraman.transfer.client.front.util.FrontUtil;
import com.xforceplus.ultraman.transfer.common.context.MetadataContextHolder;
import com.xforceplus.ultraman.transfer.common.util.JsonUtils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/metadatas"})
public class BocpClientOSSMetadataController {
    private static final Logger log = LoggerFactory.getLogger(BocpClientOSSMetadataController.class);
    private OqsSdkProperties oqsSdkProperties;
    private MetadataAliyunOSSClient metadataClient;

    public BocpClientOSSMetadataController(OqsSdkProperties oqsSdkProperties, MetadataAliyunOSSClient metadataAliyunOSSClient) {
        this.oqsSdkProperties = oqsSdkProperties;
        this.metadataClient = metadataAliyunOSSClient;
    }

    @GetMapping(value={"/version"})
    @ResponseBody
    public ResponseEntity<String> envAppVersion() {
        String envCode = FrontUtil.getEnvCode(this.oqsSdkProperties.getAuth().getEnv(), this.oqsSdkProperties.getAuth().getEnvCode());
        if (StringUtils.isBlank((CharSequence)envCode)) {
            return ResponseEntity.badRequest().build();
        }
        return ResponseEntity.ok((Object)this.metadataClient.loadEnvAppVersion(envCode, this.oqsSdkProperties.getAuth().getAppCode()));
    }

    @GetMapping(value={"/versions/{version:.+}"})
    @ResponseBody
    public ResponseEntity<String> appVersion(@PathVariable String version) {
        return ResponseEntity.ok((Object)this.metadataClient.loadAppVersionStr(MetadataContextHolder.appId(), version));
    }

    @GetMapping(value={"/pages/{pageId}/v/{pageVersion:.+}/_"})
    @ResponseBody
    public ResponseEntity<String> pageInfo(@PathVariable Long pageId, @PathVariable String pageVersion) {
        return ResponseEntity.ok((Object)this.metadataClient.loadMetadataSStr(MetadataContextHolder.appId(), SchemaMetadataType.PAGE, pageId, pageVersion, "_"));
    }

    @GetMapping(value={"/pages/{pageId}/v/{pageVersion:.+}/tenants/{tenantCode}/_"})
    @ResponseBody
    public ResponseEntity<String> tenantPageInfo(@PathVariable Long pageId, @PathVariable String pageVersion, @PathVariable String tenantCode) {
        return ResponseEntity.ok((Object)this.metadataClient.loadTenantMetadataSStr(MetadataContextHolder.appId(), SchemaMetadataType.PAGE, pageId, pageVersion, tenantCode, "_"));
    }

    @GetMapping(value={"/pages/{pageId}/v/{pageVersion:.+}/boSettings/{boSettingId}"})
    @ResponseBody
    public ResponseEntity<String> pageSetting(@PathVariable Long pageId, @PathVariable String pageVersion, @PathVariable Long boSettingId) {
        return ResponseEntity.ok((Object)this.metadataClient.loadMetadataSItemStr(MetadataContextHolder.appId(), SchemaMetadataType.PAGE, pageId, pageVersion, "boSettings", boSettingId));
    }

    @GetMapping(value={"/pages/{pageId}/v/{pageVersion:.+}/tenants/{tenantCode}/boSettings/{boSettingId}"})
    @ResponseBody
    public ResponseEntity<String> tenantPageSetting(@PathVariable Long pageId, @PathVariable String pageVersion, @PathVariable String tenantCode, @PathVariable Long boSettingId) {
        return ResponseEntity.ok((Object)this.metadataClient.loadTenantMetadataSItemStr(MetadataContextHolder.appId(), SchemaMetadataType.PAGE, pageId, pageVersion, tenantCode, "boSettings", boSettingId));
    }

    @GetMapping(value={"/forms/{formId}/v/{formVersion:.+}/_"})
    @ResponseBody
    public ResponseEntity<String> formInfo(@PathVariable Long formId, @PathVariable String formVersion) {
        return ResponseEntity.ok((Object)this.metadataClient.loadMetadataSStr(MetadataContextHolder.appId(), SchemaMetadataType.FORM, formId, formVersion, "_"));
    }

    @GetMapping(value={"/forms/{formId}/v/{formVersion:.+}/tenants/{tenantCode}/_"})
    @ResponseBody
    public ResponseEntity<String> tenantFormInfo(@PathVariable Long formId, @PathVariable String formVersion, @PathVariable String tenantCode) {
        return ResponseEntity.ok((Object)this.metadataClient.loadTenantMetadataSStr(MetadataContextHolder.appId(), SchemaMetadataType.FORM, formId, formVersion, tenantCode, "_"));
    }

    @GetMapping(value={"/pageSettings/{pageSettingId}/v/{pageSettingVersion:.+}/_"})
    @ResponseBody
    public ResponseEntity<String> newPageInfo(@PathVariable Long pageSettingId, @PathVariable String pageSettingVersion) {
        return ResponseEntity.ok((Object)this.metadataClient.loadMetadataSStr(MetadataContextHolder.appId(), SchemaMetadataType.PAGE_SETTING, pageSettingId, pageSettingVersion, "_"));
    }

    @GetMapping(value={"/pageSettings/{pageSettingId}/v/{pageSettingVersion:.+}/tenants/{tenantCode}/_"})
    @ResponseBody
    public ResponseEntity<String> tenantNewPageInfo(@PathVariable Long pageSettingId, @PathVariable String pageSettingVersion, @PathVariable String tenantCode) {
        return ResponseEntity.ok((Object)this.metadataClient.loadTenantMetadataSStr(MetadataContextHolder.appId(), SchemaMetadataType.PAGE_SETTING, pageSettingId, pageSettingVersion, tenantCode, "_"));
    }

    @GetMapping(value={"/flows/{flowId}/v/{flowVersion:.+}/_"})
    @ResponseBody
    public ResponseEntity<String> flowSetting(@PathVariable Long flowId, @PathVariable String flowVersion) {
        return ResponseEntity.ok((Object)this.metadataClient.loadMetadataSStr(MetadataContextHolder.appId(), SchemaMetadataType.FLOW, flowId, flowVersion, "_"));
    }

    @GetMapping(value={"/flows/{flowId}/v/{flowVersion:.+}/tenants/{tenantCode}/_"})
    @ResponseBody
    public ResponseEntity<String> tenantFlowSetting(@PathVariable Long flowId, @PathVariable String flowVersion, @PathVariable String tenantCode) {
        return ResponseEntity.ok((Object)this.metadataClient.loadTenantMetadataSStr(MetadataContextHolder.appId(), SchemaMetadataType.FLOW, flowId, flowVersion, tenantCode, "_"));
    }

    @GetMapping(value={"/flows/{flowId}/v/{flowVersion:.+}/_front"})
    @ResponseBody
    public ResponseEntity<String> flowFrontSetting(@PathVariable Long flowId, @PathVariable String flowVersion) {
        return ResponseEntity.ok((Object)this.metadataClient.loadMetadataSStr(MetadataContextHolder.appId(), SchemaMetadataType.FLOW, flowId, flowVersion, "_front"));
    }

    @GetMapping(value={"/flows/{flowId}/v/{flowVersion:.+}/tenants/{tenantCode}/_front"})
    @ResponseBody
    public ResponseEntity<String> tenantFlowFrontSetting(@PathVariable Long flowId, @PathVariable String flowVersion, @PathVariable String tenantCode) {
        return ResponseEntity.ok((Object)this.metadataClient.loadTenantMetadataSStr(MetadataContextHolder.appId(), SchemaMetadataType.FLOW, flowId, flowVersion, tenantCode, "_front"));
    }

    @GetMapping(value={"/appI18nLocales/v/{appI18nLocaleVersion:.+}/_"})
    @ResponseBody
    public ResponseEntity<String> appI18nLocale(@PathVariable String appI18nLocaleVersion) {
        return ResponseEntity.ok((Object)this.metadataClient.loadMetadataStr(MetadataContextHolder.appId(), SchemaMetadataType.APP_I18N_LOCALE, appI18nLocaleVersion));
    }

    @GetMapping(value={"/apps/{appId}/appI18nLocales/v/{appI18nLocaleVersion:.+}/_"})
    @ResponseBody
    public ResponseEntity<String> appI18nLocale(@PathVariable Long appId, @PathVariable String appI18nLocaleVersion) {
        return ResponseEntity.ok((Object)this.metadataClient.loadMetadataStr(appId, SchemaMetadataType.APP_I18N_LOCALE, appI18nLocaleVersion));
    }

    @GetMapping(value={"/appI18nResources/{appI18nResourceId}/v/{appI18nResourceVersion:.+}/_"})
    @ResponseBody
    public ResponseEntity<String> appI18nResource(@PathVariable Long appI18nResourceId, @PathVariable String appI18nResourceVersion) {
        return ResponseEntity.ok((Object)this.metadataClient.loadMetadataSStr(MetadataContextHolder.appId(), SchemaMetadataType.APP_I18N_RESOURCE, appI18nResourceId, appI18nResourceVersion, "_"));
    }

    @GetMapping(value={"/appI18nResources/{appI18nResourceId}/v/{appI18nResourceVersion:.+}/_i18n"})
    @ResponseBody
    public ResponseEntity<String> appI18nResourceCommonDataStruct(@PathVariable Long appI18nResourceId, @PathVariable String appI18nResourceVersion) {
        return ResponseEntity.ok((Object)this.metadataClient.loadMetadataSStr(MetadataContextHolder.appId(), SchemaMetadataType.APP_I18N_RESOURCE, appI18nResourceId, appI18nResourceVersion, "_i18n"));
    }

    @GetMapping(value={"/appI18nResources/customs"})
    @ResponseBody
    public ResponseEntity<List<String>> getCustomI18nResources() {
        String envCode = FrontUtil.getEnvCode(this.oqsSdkProperties.getAuth().getEnv(), this.oqsSdkProperties.getAuth().getEnvCode());
        if (StringUtils.isBlank((CharSequence)envCode)) {
            return ResponseEntity.badRequest().build();
        }
        String envAppVersion = this.metadataClient.loadEnvAppVersion(envCode, this.oqsSdkProperties.getAuth().getAppCode());
        SchemaAppVersion schemaAppVersion = (SchemaAppVersion)JsonUtils.json2Object((String)envAppVersion, SchemaAppVersion.class);
        if (null == schemaAppVersion) {
            return ResponseEntity.badRequest().build();
        }
        return ResponseEntity.ok((Object)Optional.ofNullable(schemaAppVersion.getAppI18nResources()).map(map -> map.values().stream().filter(o -> AppI18nResourceType.CUSTOM.equals((Object)o.getType())).map(o -> this.metadataClient.loadMetadataSStr(MetadataContextHolder.appId(), SchemaMetadataType.APP_I18N_RESOURCE, Long.valueOf(o.getId()), o.getVersion(), "_")).collect(Collectors.toList())).orElse(Lists.newArrayList()));
    }
}

