/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.transfer.client.ddl;

import com.xforceplus.ultraman.transfer.client.IBocpClient;
import com.xforceplus.ultraman.transfer.client.config.OqsSdkProperties;
import com.xforceplus.ultraman.transfer.client.ddl.DdlDemoEvent;
import com.xforceplus.ultraman.transfer.common.util.JsonUtils;
import com.xforceplus.ultraman.transfer.common.util.MessageUtils;
import com.xforceplus.ultraman.transfer.domain.entity.TransferMessage;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public class BocpClientDdlEventListener {
    private static final Logger log = LoggerFactory.getLogger(BocpClientDdlEventListener.class);
    private OqsSdkProperties oqsSdkProperties;
    private IBocpClient bocpClient;

    public BocpClientDdlEventListener(OqsSdkProperties oqsSdkProperties, IBocpClient bocpClient) {
        this.oqsSdkProperties = oqsSdkProperties;
        this.bocpClient = bocpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener(value={DdlDemoEvent.class})
    public void onApplicationEvent(DdlDemoEvent event) {
        TransferMessage message = new TransferMessage();
        message.setId(event.getMessageId());
        message.setHandleSuccess(event.isHandleSuccess());
        message.setHandleMessage(event.getHandleMessage());
        message.setAppId(Long.valueOf(this.oqsSdkProperties.getAuth().getAppId()));
        message.setEnv(this.oqsSdkProperties.getAuth().getEnv());
        TransferMessage replyMessage = null;
        try {
            Thread.sleep(1000L);
            log.info("event trigger executing ddl");
            this.bocpClient.sendMessage(JsonUtils.object2Json(replyMessage));
        }
        catch (InterruptedException e) {
            try {
                log.error("dll reply failed!", (Throwable)e);
                replyMessage = MessageUtils.buildReplyMessage((TransferMessage)message, (boolean)false, (String)ExceptionUtils.getStackTrace((Throwable)e));
                this.bocpClient.sendMessage(JsonUtils.object2Json((Object)replyMessage));
            }
            catch (Throwable throwable) {
                this.bocpClient.sendMessage(JsonUtils.object2Json(replyMessage));
                throw throwable;
            }
        }
    }
}

