/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.transfer.client.front.runtime;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.utils.IOUtils;
import com.aliyun.oss.model.OSSObject;
import com.xforceplus.ultraman.metadata.jsonschema.enums.SchemaMetadataType;
import com.xforceplus.ultraman.transfer.client.front.runtime.AliyunOSSConstant;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataAliyunOSSClient {
    private static final Logger log = LoggerFactory.getLogger(MetadataAliyunOSSClient.class);
    private final OSS oss;

    public MetadataAliyunOSSClient(OSS oss) {
        this.oss = oss;
    }

    public String loadAppVersionStr(Long appId, String version) {
        String filePath = AliyunOSSConstant.getAppVersionFilePath(appId, version);
        return this.getDataStrFromOSS(filePath);
    }

    public String loadEnvAppVersion(String envCode, String appCode) {
        String filePath = AliyunOSSConstant.getEnvAppVersionFilePath(envCode, appCode);
        return this.getDataStrFromOSS(filePath);
    }

    public String loadMetadataStr(Long appId, SchemaMetadataType metadataType, String version) {
        String filePath = AliyunOSSConstant.getMetadataFilePath(metadataType, appId, version);
        return this.getDataStrFromOSS(filePath);
    }

    public String loadMetadataSStr(Long appId, SchemaMetadataType metadataType, Long metadataId, String version, String fileName) {
        String filePath = AliyunOSSConstant.getMetadataSFilePath(metadataType, appId, metadataId, version, fileName);
        return this.getDataStrFromOSS(filePath);
    }

    public String loadMetadataSItemStr(Long appId, SchemaMetadataType metadataType, Long metadataId, String version, String dirName, Long metadataItemId) {
        String filePath = AliyunOSSConstant.getMetadataSItemFilePath(metadataType, appId, metadataId, version, dirName, metadataItemId);
        return this.getDataStrFromOSS(filePath);
    }

    public String loadTenantMetadataSStr(Long appId, SchemaMetadataType metadataType, Long metadataId, String version, String tenantCode, String fileName) {
        String filePath = AliyunOSSConstant.getTenantMetadataSFilePath(metadataType, appId, metadataId, version, tenantCode, fileName);
        return this.getDataStrFromOSS(filePath);
    }

    public String loadTenantMetadataSItemStr(Long appId, SchemaMetadataType metadataType, Long metadataId, String version, String tenantCode, String dirName, Long metadataItemId) {
        String filePath = AliyunOSSConstant.getTenantMetadataSItemFilePath(metadataType, appId, metadataId, version, tenantCode, dirName, metadataItemId);
        return this.getDataStrFromOSS(filePath);
    }

    private String getDataStrFromOSS(String filePath) {
        try {
            if (!this.oss.doesObjectExist("xforcecloud", filePath)) {
                log.debug("filePath {} not found in oss", (Object)filePath);
                return null;
            }
            OSSObject ossObject = this.oss.getObject("xforcecloud", filePath);
            return IOUtils.readStreamAsString((InputStream)ossObject.getObjectContent(), (String)"UTF-8");
        }
        catch (OSSException oe) {
            log.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
            log.error("Error Message:" + oe.getErrorMessage());
            log.error("Error Code:" + oe.getErrorCode());
            log.error("Request ID:" + oe.getRequestId());
            log.error("Host ID:" + oe.getHostId());
        }
        catch (ClientException ce) {
            log.error("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
            log.error("Error Message:" + ce.getMessage());
        }
        catch (Exception e) {
            log.error("could not load tenant metadata", (Throwable)e);
        }
        return null;
    }
}

