/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.transfer.client.thread;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageWorkerManager {
    private static final Logger log = LoggerFactory.getLogger(MessageWorkerManager.class);
    private ExecutorService threadPool;

    @PostConstruct
    public void init() {
        this.threadPool = Executors.newSingleThreadExecutor();
    }

    @PreDestroy
    public void destroy() throws InterruptedException {
        if (!this.threadPool.isShutdown()) {
            this.threadPool.shutdown();
            this.threadPool.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
    }

    public CompletableFuture<Void> execute(Runnable messageWorker) {
        return CompletableFuture.runAsync(messageWorker, this.threadPool);
    }
}

