package com.xforceplus.ultraman.transfer.client.thread;

import lombok.extern.slf4j.Slf4j;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import java.util.concurrent.*;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2023/5/6 17:54
 * Description:
 * History:
 */
@Slf4j
public class MessageWorkerManager {

    private ExecutorService threadPool;

    @PostConstruct
    public void init() {
        threadPool = Executors.newSingleThreadExecutor();
    }

    @PreDestroy
    public void destroy() throws InterruptedException {
        if(!this.threadPool.isShutdown()) {
            this.threadPool.shutdown();
            this.threadPool.awaitTermination(1000, TimeUnit.MILLISECONDS);
        }
    }

    public CompletableFuture<Void> execute(Runnable messageWorker) {
        return CompletableFuture.runAsync(messageWorker, threadPool);
    }
}
