/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.transfer.client;

import com.xforceplus.ultraman.transfer.client.config.BocpClientSetting;
import com.xforceplus.ultraman.transfer.client.config.OqsSdkProperties;
import com.xforceplus.ultraman.transfer.client.listener.IBocpServerMessageListener;
import com.xforceplus.ultraman.transfer.common.util.JsonUtils;
import com.xforceplus.ultraman.transfer.common.util.MessageUtils;
import com.xforceplus.ultraman.transfer.common.util.TransferUtils;
import com.xforceplus.ultraman.transfer.domain.entity.TransferMessage;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BocpClient
extends WebSocketListener {
    private static final Logger log = LoggerFactory.getLogger(BocpClient.class);
    private static final Integer INTERVAL_IN_MILLI_SECONDS = 15000;
    private String clientId;
    private OkHttpClient mOkHttpClient;
    private WebSocket webSocket;
    private Request mRequest;
    private BocpClientSetting bocpClientSetting;
    private OqsSdkProperties oqsSdkProperties;
    private volatile boolean isConnected = false;
    private List<IBocpServerMessageListener> listeners;
    private CountDownLatch latch = new CountDownLatch(1);

    public BocpClient(BocpClientSetting bocpClientSetting, OqsSdkProperties oqsSdkProperties, List<IBocpServerMessageListener> listeners) {
        this.oqsSdkProperties = oqsSdkProperties;
        this.bocpClientSetting = bocpClientSetting;
        this.clientId = TransferUtils.getAppEnvClientKey((String)oqsSdkProperties.getAuth().getAppId(), (String)oqsSdkProperties.getAuth().getEnv(), (String)UUID.randomUUID().toString());
        this.mOkHttpClient = this.buildClient();
        this.mRequest = this.buildRequest();
        this.listeners = listeners == null ? Collections.emptyList() : listeners;
        this.listeners.forEach(x -> x.setBocpClient(this));
        log.debug("request info {}", (Object)this.mRequest);
        this.connect();
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void onOpen(WebSocket webSocket, Response response) {
        this.isConnected = true;
        log.info("success to create websocket connection {}", (Object)response.body());
    }

    public void onMessage(WebSocket webSocket, String message) {
        log.debug("receive message :{}", (Object)message);
        TransferMessage transferMessage = (TransferMessage)JsonUtils.json2Object((String)message, TransferMessage.class);
        Optional.ofNullable(this.listeners).orElseGet(Collections::emptyList).forEach(listener -> {
            try {
                listener.onTransferMessage(transferMessage).thenAccept(x -> this.latch.countDown());
            }
            catch (Throwable e) {
                log.error("execute message task failed!", e);
            }
        });
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        this.isConnected = false;
        log.warn("websocket connection closed, code :{}, reason:{}", (Object)code, (Object)reason);
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        this.isConnected = false;
        log.warn("failed to create websocket connection", t);
        this.retry();
    }

    public void sendMessage(String message) {
        boolean success;
        if (!Optional.ofNullable(this.webSocket).isPresent()) {
            this.connect();
        }
        log.debug("websocket send message {}: {}", (Object)((success = this.webSocket.send(message)) ? "success" : "failed"), (Object)message);
    }

    private synchronized void connect() {
        if (this.webSocket == null || !this.isConnected) {
            log.debug("start to create websocket connection");
            if (this.mRequest == null) {
                this.mRequest = this.buildRequest();
            }
            this.mOkHttpClient.dispatcher().cancelAll();
            try {
                this.webSocket = this.mOkHttpClient.newWebSocket(this.mRequest, (WebSocketListener)this);
                this.isConnected = true;
            }
            catch (Exception e) {
                this.isConnected = false;
            }
        }
    }

    private synchronized void retry() {
        try {
            Thread.sleep(INTERVAL_IN_MILLI_SECONDS.intValue());
            log.info("retry to create websocket connection");
            this.connect();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private OkHttpClient buildClient() {
        OkHttpClient.Builder builder = new OkHttpClient().newBuilder().retryOnConnectionFailure(true).readTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).pingInterval(10L, TimeUnit.SECONDS);
        if (this.bocpClientSetting.getBocp().isUseSsl()) {
            X509TrustManager trustManager = new X509TrustManager(){

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
            return builder.sslSocketFactory(sslContext.getSocketFactory(), trustManager).hostnameVerifier((s, sslSession) -> true).build();
        }
        return builder.build();
    }

    private Request buildRequest() {
        return new Request.Builder().url(MessageUtils.getRealWsUrl((String)this.bocpClientSetting.getBocp().getHost(), (boolean)this.bocpClientSetting.getBocp().isUseSsl())).addHeader("socket_token", "271b876d64d04c7d9b67e92af8fdc6fc").addHeader("app_id", this.oqsSdkProperties.getAuth().getAppId()).addHeader("env", this.oqsSdkProperties.getAuth().getEnv()).addHeader("client_id", this.clientId).build();
    }
}

