/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.transfer.client.config;

import com.xforceplus.ultraman.transfer.client.BocpClient;
import com.xforceplus.ultraman.transfer.client.config.BocpClientSetting;
import com.xforceplus.ultraman.transfer.client.config.OqsSdkProperties;
import com.xforceplus.ultraman.transfer.client.controller.BocpClientController;
import com.xforceplus.ultraman.transfer.client.listener.IBocpServerMessageListener;
import com.xforceplus.ultraman.transfer.client.listener.impl.BocpServerMessageListenerImpl;
import com.xforceplus.ultraman.transfer.client.thread.MessageWorkerManager;
import com.xforceplus.ultraman.transfer.common.event.SDKMetadataEvent;
import com.xforceplus.ultraman.transfer.common.event.publisher.EventStream;
import com.xforceplus.ultraman.transfer.common.event.publisher.RxEventStream;
import com.xforceplus.ultraman.transfer.storage.aggregator.strategy.MetadataStorageRepository;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnProperty(prefix="ultraman.transfer", name={"enabled"}, matchIfMissing=false)
@EnableConfigurationProperties(value={BocpClientSetting.class})
public class BocpClientConfiguration {
    @Bean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @Bean
    public BocpClient bocpClient(BocpClientSetting bocpClientSetting, OqsSdkProperties oqsSdkProperties, @Autowired(required=false) List<IBocpServerMessageListener> listeners) {
        return new BocpClient(bocpClientSetting, oqsSdkProperties, listeners);
    }

    @Bean
    public MessageWorkerManager messageWorkerManager() {
        return new MessageWorkerManager();
    }

    @Bean
    public EventStream<SDKMetadataEvent> eventEventStream() {
        return new RxEventStream();
    }

    @Bean
    public IBocpServerMessageListener serverMessageListener(BocpClientSetting bocpClientSetting, OqsSdkProperties oqsSdkProperties, MetadataStorageRepository metadataStorageRepository, MessageWorkerManager messageWorkerManager, EventStream<SDKMetadataEvent> eventStream) {
        return new BocpServerMessageListenerImpl(bocpClientSetting, oqsSdkProperties, metadataStorageRepository, messageWorkerManager, eventStream);
    }

    @Bean
    public BocpClientController bocpClientController(OqsSdkProperties oqsSdkProperties, BocpClient bocpClient) {
        return new BocpClientController(oqsSdkProperties, bocpClient);
    }
}

