/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.transfer.client.controller;

import com.google.common.collect.Maps;
import com.xforceplus.ultraman.metadata.jsonschema.enums.SchemaMetadataType;
import com.xforceplus.ultraman.transfer.client.BocpClient;
import com.xforceplus.ultraman.transfer.client.config.OqsSdkProperties;
import com.xforceplus.ultraman.transfer.common.context.MetadataContextHolder;
import com.xforceplus.ultraman.transfer.common.util.JsonUtils;
import com.xforceplus.ultraman.transfer.domain.entity.TransferMessage;
import com.xforceplus.ultraman.transfer.domain.enums.MessageType;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/bocpclient"})
public class BocpClientController {
    private OqsSdkProperties oqsSdkProperties;
    private BocpClient bocpClient;

    public BocpClientController(OqsSdkProperties oqsSdkProperties, BocpClient bocpClient) {
        this.oqsSdkProperties = oqsSdkProperties;
        this.bocpClient = bocpClient;
    }

    @PostMapping(value={"/send"})
    @ResponseBody
    public void sendReplayMessage(@RequestBody TransferMessage replyMessage) {
        this.bocpClient.sendMessage(JsonUtils.object2Json((Object)replyMessage));
    }

    @GetMapping(value={"/pull"})
    @ResponseBody
    public void pull() {
        TransferMessage message = new TransferMessage();
        message.setAppId(Long.valueOf(this.oqsSdkProperties.getAuth().getAppId()));
        message.setEnv(this.oqsSdkProperties.getAuth().getEnv());
        message.setMessageType(MessageType.CLIENT_PULL);
        message.setForceUpdate(true);
        this.bocpClient.sendMessage(JsonUtils.object2Json((Object)message));
    }

    @GetMapping(value={"/current"})
    @ResponseBody
    public ResponseEntity current() {
        CurrentInfo currentInfo = new CurrentInfo();
        currentInfo.setEnv(this.oqsSdkProperties.getAuth().getEnv());
        currentInfo.setVersion(MetadataContextHolder.currentVersion());
        if ("99".equals(this.oqsSdkProperties.getAuth().getEnv())) {
            String version = MetadataContextHolder.currentVersion();
            String[] split = version.split("\\.");
            String timestamp = split[1];
            String format = LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.valueOf(timestamp)), ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            currentInfo.setVersion(split[0] + "." + format);
        }
        currentInfo.setAppCode(MetadataContextHolder.appCode());
        currentInfo.setAppCodeForDB(MetadataContextHolder.appCodeForDB());
        currentInfo.setAppId(MetadataContextHolder.appId());
        return ResponseEntity.ok((Object)currentInfo);
    }

    public static class CurrentInfo {
        private Long appId = null;
        private String env = null;
        private String appCode = null;
        private String appCodeForDB = null;
        private String version = "";
        private Map<SchemaMetadataType, Object> metadataMap = Maps.newConcurrentMap();

        public Long getAppId() {
            return this.appId;
        }

        public String getEnv() {
            return this.env;
        }

        public String getAppCode() {
            return this.appCode;
        }

        public String getAppCodeForDB() {
            return this.appCodeForDB;
        }

        public String getVersion() {
            return this.version;
        }

        public Map<SchemaMetadataType, Object> getMetadataMap() {
            return this.metadataMap;
        }

        public void setAppId(Long appId) {
            this.appId = appId;
        }

        public void setEnv(String env) {
            this.env = env;
        }

        public void setAppCode(String appCode) {
            this.appCode = appCode;
        }

        public void setAppCodeForDB(String appCodeForDB) {
            this.appCodeForDB = appCodeForDB;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setMetadataMap(Map<SchemaMetadataType, Object> metadataMap) {
            this.metadataMap = metadataMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CurrentInfo)) {
                return false;
            }
            CurrentInfo other = (CurrentInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$appId = this.getAppId();
            Long other$appId = other.getAppId();
            if (this$appId == null ? other$appId != null : !((Object)this$appId).equals(other$appId)) {
                return false;
            }
            String this$env = this.getEnv();
            String other$env = other.getEnv();
            if (this$env == null ? other$env != null : !this$env.equals(other$env)) {
                return false;
            }
            String this$appCode = this.getAppCode();
            String other$appCode = other.getAppCode();
            if (this$appCode == null ? other$appCode != null : !this$appCode.equals(other$appCode)) {
                return false;
            }
            String this$appCodeForDB = this.getAppCodeForDB();
            String other$appCodeForDB = other.getAppCodeForDB();
            if (this$appCodeForDB == null ? other$appCodeForDB != null : !this$appCodeForDB.equals(other$appCodeForDB)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            Map<SchemaMetadataType, Object> this$metadataMap = this.getMetadataMap();
            Map<SchemaMetadataType, Object> other$metadataMap = other.getMetadataMap();
            return !(this$metadataMap == null ? other$metadataMap != null : !((Object)this$metadataMap).equals(other$metadataMap));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CurrentInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $appId = this.getAppId();
            result = result * 59 + ($appId == null ? 43 : ((Object)$appId).hashCode());
            String $env = this.getEnv();
            result = result * 59 + ($env == null ? 43 : $env.hashCode());
            String $appCode = this.getAppCode();
            result = result * 59 + ($appCode == null ? 43 : $appCode.hashCode());
            String $appCodeForDB = this.getAppCodeForDB();
            result = result * 59 + ($appCodeForDB == null ? 43 : $appCodeForDB.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            Map<SchemaMetadataType, Object> $metadataMap = this.getMetadataMap();
            result = result * 59 + ($metadataMap == null ? 43 : ((Object)$metadataMap).hashCode());
            return result;
        }

        public String toString() {
            return "BocpClientController.CurrentInfo(appId=" + this.getAppId() + ", env=" + this.getEnv() + ", appCode=" + this.getAppCode() + ", appCodeForDB=" + this.getAppCodeForDB() + ", version=" + this.getVersion() + ", metadataMap=" + this.getMetadataMap() + ")";
        }
    }
}

