/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.transfer.client.listener.impl;

import com.xforceplus.ultraman.metadata.jsonschema.enums.SchemaMetadataType;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaApp;
import com.xforceplus.ultraman.transfer.client.BocpClient;
import com.xforceplus.ultraman.transfer.client.config.BocpClientSetting;
import com.xforceplus.ultraman.transfer.client.config.OqsSdkProperties;
import com.xforceplus.ultraman.transfer.client.listener.IBocpServerMessageListener;
import com.xforceplus.ultraman.transfer.client.thread.MessageWorkerManager;
import com.xforceplus.ultraman.transfer.common.context.MetadataContextHolder;
import com.xforceplus.ultraman.transfer.common.event.SDKMetadataEvent;
import com.xforceplus.ultraman.transfer.common.event.publisher.EventStream;
import com.xforceplus.ultraman.transfer.common.util.JsonUtils;
import com.xforceplus.ultraman.transfer.common.util.MessageUtils;
import com.xforceplus.ultraman.transfer.common.util.VersionUtils;
import com.xforceplus.ultraman.transfer.domain.entity.TransferMessage;
import com.xforceplus.ultraman.transfer.domain.enums.MessageType;
import com.xforceplus.ultraman.transfer.storage.aggregator.strategy.MetadataStorageRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BocpServerMessageListenerImpl
implements IBocpServerMessageListener {
    private static final Logger log = LoggerFactory.getLogger(BocpServerMessageListenerImpl.class);
    private final Integer GET_METADATA_RETRY_TIMES = 3;
    private final Integer GET_METADATA_WAIT_TIME = 5000;
    private BocpClient bocpClient;
    private BocpClientSetting bocpClientSetting;
    private OqsSdkProperties oqsSdkProperties;
    private MetadataStorageRepository metadataStorageRepository;
    private MessageWorkerManager messageWorkerManager;
    private EventStream<SDKMetadataEvent> eventEventStream;

    public BocpServerMessageListenerImpl(BocpClientSetting bocpClientSetting, OqsSdkProperties oqsSdkProperties, MetadataStorageRepository metadataStorageRepository, MessageWorkerManager messageWorkerManager, EventStream<SDKMetadataEvent> eventEventStream) {
        this.bocpClientSetting = bocpClientSetting;
        this.oqsSdkProperties = oqsSdkProperties;
        this.metadataStorageRepository = metadataStorageRepository;
        this.messageWorkerManager = messageWorkerManager;
        this.eventEventStream = eventEventStream;
    }

    @Override
    public void setBocpClient(BocpClient bocpClient) {
        this.bocpClient = bocpClient;
    }

    @Override
    public CompletableFuture<Void> onTransferMessage(TransferMessage message) {
        Runnable messageWorker = () -> {
            log.debug("handle message : {}", (Object)message);
            if (VersionUtils.compare((String)message.getVersion(), (String)MetadataContextHolder.currentVersion()) == 0 && !message.isForceUpdate()) {
                log.debug("message has same version with current version {}, discard!", (Object)message.getVersion());
                return;
            }
            if (MessageType.CLIENT_CONNECT.equals((Object)message.getMessageType())) {
                this.dealMessageTriggerByClient(message);
            } else if (MessageType.CLIENT_PULL.equals((Object)message.getMessageType())) {
                this.randomDelay();
                this.dealMessageTriggerByClient(message);
            } else if (MessageType.BOCP_DEPLOY.equals((Object)message.getMessageType())) {
                this.randomDelay();
                this.dealWithDeployMessage(message);
            } else {
                log.warn("unknown message type : {}, discard!", (Object)message.getMessageType());
            }
        };
        return this.messageWorkerManager.execute(messageWorker);
    }

    private void dealMessageTriggerByClient(TransferMessage message) {
        try {
            if (!message.isHandleSuccess()) {
                log.warn(String.format("handle message failed, %s", message.getHandleMessage()));
                return;
            }
            log.info("start to pull metadata with version " + message.getVersion());
            SchemaApp schemaApp = this.prepareMetadata(message);
            this.publishMetadataForSdk(message, schemaApp);
        }
        catch (Throwable throwable) {
            log.error("pull metadata failed when connected or pulled!", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void dealWithDeployMessage(TransferMessage message) {
        TransferMessage replyMessage = null;
        try {
            log.info("start to update metadata with version " + message.getVersion());
            SchemaApp schemaApp = this.prepareMetadata(message);
            this.publishMetadataForSdk(message, schemaApp);
            replyMessage = MessageUtils.buildReplyMessage((TransferMessage)message, (boolean)true, (String)"\u7248\u672c\u90e8\u7f72\u6210\u529f");
        }
        catch (RuntimeException re) {
            log.error("update metadata failed: {} ", (Object)re.getMessage());
            replyMessage = MessageUtils.buildReplyMessage((TransferMessage)message, (boolean)false, (String)re.getMessage());
            this.bocpClient.sendMessage(JsonUtils.object2Json((Object)replyMessage));
        }
        catch (Throwable throwable) {
            log.error("update metadata failed!", throwable);
            replyMessage = MessageUtils.buildReplyMessage((TransferMessage)message, (boolean)false, (String)ExceptionUtils.getStackTrace((Throwable)throwable));
            this.bocpClient.sendMessage(JsonUtils.object2Json((Object)replyMessage));
            {
                catch (Throwable throwable2) {
                    this.bocpClient.sendMessage(JsonUtils.object2Json(replyMessage));
                    throw throwable2;
                }
            }
        }
        this.bocpClient.sendMessage(JsonUtils.object2Json((Object)replyMessage));
    }

    private SchemaApp prepareMetadata(TransferMessage message) throws InterruptedException {
        List entitys = null;
        for (int count = 0; count < this.GET_METADATA_RETRY_TIMES && (null == (entitys = this.metadataStorageRepository.getMetadatas(Long.valueOf(this.oqsSdkProperties.getAuth().getAppId()), message.getVersion(), SchemaMetadataType.ENTITY)) || entitys.isEmpty()); ++count) {
            Thread.sleep(this.GET_METADATA_WAIT_TIME.intValue());
            log.debug("retry to get entity metadata");
        }
        if (null == entitys || entitys.isEmpty()) {
            throw new RuntimeException("failed to get entity metadata");
        }
        log.info(String.format("entity metadata received, num: %d", entitys.size()));
        List dicts = this.metadataStorageRepository.getMetadatas(Long.valueOf(this.oqsSdkProperties.getAuth().getAppId()), message.getVersion(), SchemaMetadataType.DICT);
        log.info(String.format("dict metadata received, num: %d", null == dicts ? 0 : dicts.size()));
        List actions = this.metadataStorageRepository.getMetadatas(Long.valueOf(this.oqsSdkProperties.getAuth().getAppId()), message.getVersion(), SchemaMetadataType.ACTION);
        log.info(String.format("action metadata received, num: %d", null == actions ? 0 : actions.size()));
        List appEvents = this.metadataStorageRepository.getMetadatas(Long.valueOf(this.oqsSdkProperties.getAuth().getAppId()), message.getVersion(), SchemaMetadataType.APP_EVENT);
        log.info(String.format("appEvent metadata received, num: %d", null == appEvents ? 0 : appEvents.size()));
        List sdkSettings = new ArrayList();
        if (this.bocpClientSetting.getBocp().getEnableSDKConfig().booleanValue()) {
            sdkSettings = this.metadataStorageRepository.getMetadatas(Long.valueOf(this.oqsSdkProperties.getAuth().getAppId()), message.getVersion(), SchemaMetadataType.SDK_SETTING);
            log.info(String.format("sdkSetting metadata received, num: %d", null == sdkSettings ? 0 : sdkSettings.size()));
        } else {
            log.info(String.format("sdkSetting metadata disabled", new Object[0]));
        }
        List flows = this.metadataStorageRepository.getMetadatas(Long.valueOf(this.oqsSdkProperties.getAuth().getAppId()), message.getVersion(), SchemaMetadataType.FLOW);
        log.info(String.format("flow metadata received, num: %d", null == flows ? 0 : flows.size()));
        SchemaApp schemaApp = new SchemaApp();
        schemaApp.setBos(entitys);
        schemaApp.setDicts(dicts);
        schemaApp.setActions(actions);
        schemaApp.setAppEvents(appEvents);
        schemaApp.setSdkSettings(sdkSettings);
        schemaApp.setFlowSettings(flows);
        if (this.bocpClientSetting.getBocp().getExtraMetadataTypes().contains(SchemaMetadataType.PAGE.code())) {
            List pages = this.metadataStorageRepository.getMetadatas(Long.valueOf(this.oqsSdkProperties.getAuth().getAppId()), message.getVersion(), SchemaMetadataType.PAGE);
            log.info(String.format("page metadata received, num: %d", null == pages ? 0 : pages.size()));
            schemaApp.setPages(pages);
        }
        if (this.bocpClientSetting.getBocp().getExtraMetadataTypes().contains(SchemaMetadataType.FORM.code())) {
            List forms = this.metadataStorageRepository.getMetadatas(Long.valueOf(this.oqsSdkProperties.getAuth().getAppId()), message.getVersion(), SchemaMetadataType.FORM);
            log.info(String.format("form metadata received, num: %d", null == forms ? 0 : forms.size()));
            schemaApp.setForms(forms);
        }
        return schemaApp;
    }

    private void publishMetadataForSdk(TransferMessage message, SchemaApp schemaApp) {
        MetadataContextHolder.update((String)this.oqsSdkProperties.getAuth().getAppId(), (TransferMessage)message, (SchemaApp)schemaApp);
        SDKMetadataEvent sdkMetadataEvent = new SDKMetadataEvent(Long.valueOf(this.oqsSdkProperties.getAuth().getAppId()), Long.valueOf(this.oqsSdkProperties.getAuth().getEnv()), MetadataContextHolder.appCode(), MetadataContextHolder.appCodeForDB(), message.getVersion(), schemaApp.getBos(), schemaApp.getDicts(), schemaApp.getFlowSettings(), schemaApp.getActions(), schemaApp.getAppEvents(), schemaApp.getSdkSettings(), schemaApp.getPages(), schemaApp.getForms(), message.getMessageType());
        this.eventEventStream.offer((Object)sdkMetadataEvent);
    }

    private void randomDelay() {
        Integer RANDOM_RANGE = 1000;
        int randomSleep = (int)(Math.random() * (double)RANDOM_RANGE.intValue());
        try {
            Thread.sleep(randomSleep);
        }
        catch (InterruptedException e) {
            log.error("sleep interrupted", (Throwable)e);
        }
    }
}

