package com.xforceplus.ultraman.transfer.client.config;

import com.xforceplus.ultraman.transfer.client.IBocpClient;
import com.xforceplus.ultraman.transfer.client.ddl.BocpClientDdlEventListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2024/1/17 18:45
 * Description:
 * History:
 */
@Configuration
@ConditionalOnProperty(prefix = "ultraman.transfer", name = "enabled", matchIfMissing = false)
public class BocpClientDdlConfiguration {

    @ConditionalOnBean(IBocpClient.class)
    @Bean
    public BocpClientDdlEventListener bocpClientDdlEventListener(OqsSdkProperties oqsSdkProperties, IBocpClient bocpClient) {
        return new BocpClientDdlEventListener(oqsSdkProperties, bocpClient);
    }


}
