package com.xforceplus.ultraman.transfer.client.config;

import com.xforceplus.ultraman.transfer.client.BocpClient;
import com.xforceplus.ultraman.transfer.client.IBocpClient;
import com.xforceplus.ultraman.transfer.client.JanusBocpHttpClient;
import com.xforceplus.ultraman.transfer.client.listener.IBocpServerMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;

@Configuration
@ConditionalOnProperty(prefix = "ultraman.transfer", name = "enabled", matchIfMissing = false)
public class JanusBocpHttpClientConfiguration {

    /**
     *     @Value("${ultraman.transfer.bocp.authUrl:https://paas-s.xforceplus.com}")
     *     String authUrl;
     *     @Value("${ultraman.transfer.bocp.clientId:tg_ultraman_auth}")
     *     String clientId;
     *     @Value("${ultraman.transfer.bocp.secret:YVFY1q123Blp9c}")
     *     String secret;
     * @param bocpClientSetting
     * @param oqsSdkProperties
     * @param listeners
     * @return
     */
    @ConditionalOnExpression("${ultraman.transfer.janus.enabled:false} == true")
    @Bean
    public IBocpClient bocpClient(BocpClientSetting bocpClientSetting, OqsSdkProperties oqsSdkProperties
            , @Autowired(required = false) List<IBocpServerMessageListener> listeners
            , @Value("${janus.url:https://janus-inte.xforceplus.com}") String janusBase
            , @Value("${janus.authentication}") String authentication
            , @Value("${janus.action.bocp}") String action
            , @Value("${ultraman.transfer.bocp.useSsl:true}") Boolean useSsl
    ) {
        /**
         * String bocpHost,
         *                            Boolean useSsl,
         *                            String apiPrefix,
         *                            OqsSdkProperties oqsSdkProperties,
         *                            MetadataHeadInterceptor metadataHeadInterceptor, List<IBocpServerMessageListener> listeners
         */
        return new JanusBocpHttpClient(janusBase, authentication, action, useSsl, oqsSdkProperties, bocpClientSetting, listeners);
    }
}
