package com.xforceplus.ultraman.transfer.client.ddl;

import com.xforceplus.ultraman.transfer.client.IBocpClient;
import com.xforceplus.ultraman.transfer.client.config.OqsSdkProperties;
import com.xforceplus.ultraman.transfer.common.util.JsonUtils;
import com.xforceplus.ultraman.transfer.common.util.MessageUtils;
import com.xforceplus.ultraman.transfer.domain.entity.TransferMessage;
import org.springframework.context.event.EventListener;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2024/1/17 18:43
 * Description:
 * History:
 */
public class BocpClientDdlEventListener {

    private OqsSdkProperties oqsSdkProperties;

    private IBocpClient bocpClient;

    public BocpClientDdlEventListener(OqsSdkProperties oqsSdkProperties, IBocpClient bocpClient) {
        this.oqsSdkProperties = oqsSdkProperties;
        this.bocpClient = bocpClient;
    }

    @EventListener({DdlDemoEvent.class})
    public void onApplicationEvent(DdlDemoEvent event) {
        TransferMessage message = new TransferMessage();
        message.setId(event.getMessageId());
        message.setHandleSuccess(event.isHandleSuccess());
        message.setHandleMessage(event.getHandleMessage());

        message.setAppId(Long.valueOf(oqsSdkProperties.getAuth().getAppId()));
        message.setEnv(oqsSdkProperties.getAuth().getEnv());

        TransferMessage replyMessage = MessageUtils.buildReplyMessage(message, true, "DDL执行成功");
        bocpClient.sendMessage(JsonUtils.object2Json(replyMessage));
    }
}
